/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.faces.model.SelectItem;
import javax.inject.Inject;
import javax.inject.Named;
import org.imixs.marty.profile.UserController;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.TextEvent;
import org.imixs.workflow.util.XMLParser;

@Named
@RequestScoped
public class CountryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(CountryController.class.getName());
    @Inject
    UserController userController;
    Comparator<SelectItem> selectItemComparator = new Comparator<SelectItem>(){

        @Override
        public int compare(SelectItem s1, SelectItem s2) {
            Collator collator = Collator.getInstance(CountryController.this.userController.getLocale());
            collator.setStrength(1);
            return collator.compare(s1.getLabel(), s2.getLabel());
        }
    };

    public List<SelectItem> getCountriesSelectItems() {
        ArrayList<SelectItem> selection = new ArrayList<SelectItem>();
        String[] locales = Locale.getISOCountries();
        logger.fine("...found " + locales.length + " countries");
        for (String countryCode : locales) {
            Locale locale = new Locale("", countryCode);
            String code = locale.getCountry();
            String country = locale.getDisplayCountry(this.userController.getLocale());
            selection.add(new SelectItem((Object)code, country + " (" + code + ")"));
        }
        Collections.sort(selection, this.selectItemComparator);
        return selection;
    }

    public String getCountryName(String countryCode) {
        Locale countryLocale = new Locale("", countryCode);
        return countryLocale.getDisplayCountry(this.userController.getLocale());
    }

    public String getCountryNames(List<String> countryCodes) {
        String result = "";
        for (String countryCode : countryCodes) {
            Locale countryLocale = new Locale("", countryCode);
            result = result + countryLocale.getDisplayCountry(this.userController.getLocale()) + ", ";
        }
        result = result.substring(0, result.length() - 2);
        return result;
    }

    public void onEvent(@Observes TextEvent event) {
        String text = event.getText();
        ItemCollection documentContext = event.getDocument();
        List tagList = XMLParser.findTags((String)text, (String)"countryname");
        logger.finest(tagList.size() + " tags found");
        for (String tag : tagList) {
            Locale locale = null;
            String sLocale = XMLParser.findAttribute((String)tag, (String)"locale");
            String separator = XMLParser.findAttribute((String)tag, (String)"separator");
            if (sLocale != null && !sLocale.isEmpty()) {
                String sCount;
                String sLang;
                StringTokenizer stLocale = new StringTokenizer(sLocale, "_");
                if (stLocale.countTokens() == 1) {
                    sLang = stLocale.nextToken();
                    sCount = sLang.toUpperCase();
                    locale = new Locale(sLang, sCount);
                } else {
                    sLang = stLocale.nextToken();
                    sCount = stLocale.nextToken();
                    locale = new Locale(sLang, sCount);
                }
            } else {
                locale = this.userController.getLocale();
            }
            String sItemName = XMLParser.findTagValue((String)tag, (String)"countryname");
            String country = "";
            if (separator == null || separator.isEmpty()) {
                String countryCode = documentContext.getItemValueString(sItemName);
                Locale countryLocale = new Locale("", countryCode);
                if (countryLocale != null) {
                    country = countryLocale.getDisplayCountry(locale);
                }
            } else {
                List countryCodes = documentContext.getItemValue(sItemName);
                for (String countryCode : countryCodes) {
                    Locale countryLocale = new Locale("", countryCode);
                    country = country + countryLocale.getDisplayCountry(locale);
                    country = country + separator;
                }
                if (country.endsWith(separator)) {
                    country = country.substring(0, country.length() - separator.length());
                }
            }
            int iStartPos = text.indexOf(tag);
            int iEndPos = text.indexOf(tag) + tag.length();
            text = text.substring(0, iStartPos) + country + text.substring(iEndPos);
        }
        event.setText(text);
    }
}

