/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.faces.model.SelectItem;

public class CustomFormItem {
    String name;
    String type;
    String label;
    boolean required;
    boolean readonly;
    String options;
    String path;
    private static Logger logger = Logger.getLogger(CustomFormItem.class.getName());

    public CustomFormItem(String name, String type, String label, boolean required, boolean readonly, String options, String path) {
        this.label = label;
        this.name = name;
        this.type = type;
        this.required = required;
        this.readonly = readonly;
        this.options = options;
        this.path = path;
        if ("custom".equalsIgnoreCase(type) && (path == null || path.isEmpty())) {
            logger.warning("Custom Form Item requires 'path' attribute - please check your BPMN model");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public List<SelectItem> getSelectItems() throws Exception {
        String[] valueList;
        ArrayList<SelectItem> selection = new ArrayList<SelectItem>();
        if (this.options == null || this.options.isEmpty()) {
            return selection;
        }
        String[] stringArray = valueList = this.options.split(";");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String aValue;
            String sValue;
            String sName = sValue = (aValue = stringArray[i]);
            if (sValue.indexOf("|") > -1) {
                sValue = sValue.substring(0, sValue.indexOf("|"));
                sName = sName.substring(sName.indexOf("|") + 1);
            }
            selection.add(new SelectItem((Object)sName.trim(), sValue.trim()));
        }
        return selection;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

