/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.imixs.workflow.engine.plugins.RulePlugin;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.WorkflowException;
import org.imixs.workflow.office.util.ValidationException;

public class ErrorHandler {
    private static Logger logger = Logger.getLogger(ErrorHandler.class.getName());

    public static void handlePluginException(PluginException pe) {
        if (RulePlugin.class.getName().equals(pe.getErrorContext()) && "VALIDATION_ERROR".equals(pe.getErrorCode()) && pe.getErrorParameters() != null && pe.getErrorParameters().length > 0) {
            Object[] messages;
            String errorCode = pe.getErrorCode();
            try {
                Locale browserLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
                ResourceBundle rb = ResourceBundle.getBundle("bundle.app", browserLocale);
                errorCode = rb.getString(pe.getErrorCode());
            }
            catch (MissingResourceException mre) {
                logger.warning("ErrorHandler: " + mre.getMessage());
            }
            for (Object aMessage : messages = pe.getErrorParameters()) {
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, errorCode, aMessage.toString()));
            }
        } else {
            ErrorHandler.addErrorMessage((WorkflowException)pe);
        }
        logger.warning("ErrorHandler cauth PluginException - error code=" + pe.getErrorCode() + " - " + pe.getMessage());
        if (logger.isLoggable(Level.FINE)) {
            pe.printStackTrace();
        }
    }

    public static void addErrorMessage(WorkflowException pe) {
        Object p;
        String errorCode = pe.getErrorCode();
        String message = pe.getMessage();
        try {
            Locale browserLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            ResourceBundle rb = ResourceBundle.getBundle("bundle.app", browserLocale);
            String messageFromBundle = rb.getString(pe.getErrorCode());
            if (messageFromBundle != null && !messageFromBundle.isEmpty()) {
                message = messageFromBundle;
            }
        }
        catch (MissingResourceException mre) {
            logger.warning("ErrorHandler: " + mre.getMessage());
        }
        if (pe instanceof PluginException) {
            p = (PluginException)pe;
            if (p.getErrorParameters() != null && p.getErrorParameters().length > 0) {
                for (int i = 0; i < p.getErrorParameters().length; ++i) {
                    message = message.replace("{" + i + "}", p.getErrorParameters()[i].toString());
                }
            }
        } else if (pe instanceof ValidationException && ((ValidationException)((Object)(p = (ValidationException)pe))).getErrorParameters() != null && ((ValidationException)((Object)p)).getErrorParameters().length > 0) {
            for (int i = 0; i < ((ValidationException)((Object)p)).getErrorParameters().length; ++i) {
                message = message.replace("{" + i + "}", ((ValidationException)((Object)p)).getErrorParameters()[i].toString());
            }
        }
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, errorCode, message));
    }

    public static void handleModelException(ModelException me) {
        String message = me.getErrorCode();
        try {
            Locale browserLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            ResourceBundle rb = ResourceBundle.getBundle("bundle.app", browserLocale);
            message = rb.getString(me.getErrorCode());
        }
        catch (MissingResourceException mre) {
            logger.warning("ErrorHandler: " + mre.getMessage());
        }
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, message, me.getMessage()));
        logger.warning("ErrorHandler cauth ModelException - error code=" + me.getErrorCode() + " - " + me.getMessage());
        if (logger.isLoggable(Level.FINE)) {
            me.printStackTrace();
        }
    }
}

