/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.util;

import java.util.List;
import java.util.logging.Logger;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.office.config.ConfigService;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Singleton
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
public class SequenceService {
    private static Logger logger = Logger.getLogger(SequenceService.class.getName());
    @EJB
    ConfigService configService;
    @EJB
    DocumentService documentService;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void computeSequenceNumber(ItemCollection documentContext) throws AccessDeniedException {
        if (documentContext.getItemValueInteger("numsequencenumber") > 0) {
            return;
        }
        ItemCollection configItemCollection = this.configService.loadConfiguration("BASIC", true);
        if (configItemCollection != null) {
            String sWorkflowGroup = documentContext.getItemValueString("$workflowgroup");
            List vNumbers = configItemCollection.getItemValue("sequencenumbers");
            String groupIdentifier = null;
            String generalIdentifier = null;
            int identifierPosition = -1;
            for (String aIdentifier : vNumbers) {
                if (aIdentifier.startsWith(sWorkflowGroup + "=")) {
                    groupIdentifier = aIdentifier;
                }
                if (!aIdentifier.startsWith("[GENERAL]=")) continue;
                generalIdentifier = aIdentifier;
            }
            if (groupIdentifier == null && generalIdentifier != null) {
                groupIdentifier = generalIdentifier;
                sWorkflowGroup = "[GENERAL]";
            }
            if (groupIdentifier != null) {
                String sequcenceNumber = groupIdentifier.substring(groupIdentifier.indexOf(61) + 1);
                long currentSequenceNumber = Long.parseLong(sequcenceNumber);
                documentContext.replaceItemValue("numsequencenumber", (Object)currentSequenceNumber);
                long newSequenceNumber = currentSequenceNumber + 1L;
                groupIdentifier = sWorkflowGroup + "=" + newSequenceNumber;
                for (int i = 0; i < vNumbers.size(); ++i) {
                    if (!((String)vNumbers.get(i)).startsWith(sWorkflowGroup + "=")) continue;
                    identifierPosition = i;
                    break;
                }
                if (identifierPosition > -1) {
                    vNumbers.set(identifierPosition, sWorkflowGroup + "=" + newSequenceNumber);
                    configItemCollection.replaceItemValue("sequencenumbers", (Object)vNumbers);
                    this.configService.save(configItemCollection);
                }
            } else {
                documentContext.removeItem("numsequencenumber");
            }
        } else {
            logger.warning("No BASIC configuration found!");
        }
    }
}

