/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.views;

import java.util.List;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.imixs.marty.profile.UserController;
import org.imixs.workflow.faces.data.ViewController;
import org.imixs.workflow.faces.util.LoginController;
import org.imixs.workflow.office.config.SetupController;

@Named
@ViewScoped
public class PortletWorklistFavorites
extends ViewController {
    private static final long serialVersionUID = 1L;
    public static final String LINK_PROPERTY = "$workitemref";
    public static final String LINK_PROPERTY_DEPRECATED = "txtworkitemref";
    private int mode = 1;
    @Inject
    protected UserController userController;
    @Inject
    LoginController loginController;
    @Inject
    SetupController setupController;
    private static Logger logger = Logger.getLogger(PortletWorklistFavorites.class.getName());

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    @PostConstruct
    public void init() {
        super.init();
        this.setPageSize(this.setupController.getPortletSize());
        this.setSortBy(this.setupController.getSortBy());
        this.setSortReverse(this.setupController.getSortReverse());
        try {
            String value = this.getCookie("imixs.office.document.mytasks.mode");
            if (value != null) {
                this.mode = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getQuery() {
        if (this.userController.getWorkitem() == null) {
            return null;
        }
        String sQuery = "";
        if (this.mode == 1) {
            List favorites = null;
            favorites = !this.userController.getWorkitem().hasItem(LINK_PROPERTY) && this.userController.getWorkitem().hasItem(LINK_PROPERTY_DEPRECATED) ? this.userController.getWorkitem().getItemValue(LINK_PROPERTY_DEPRECATED) : this.userController.getWorkitem().getItemValue(LINK_PROPERTY);
            if (favorites == null || favorites.size() == 0) {
                return null;
            }
            sQuery = "(type:\"workitem\" OR type:\"workitemarchive\") ";
            sQuery = sQuery + " ( ";
            for (String aID : favorites) {
                sQuery = sQuery + "$uniqueid:\"" + aID + "\" OR ";
            }
            sQuery = sQuery.substring(0, sQuery.length() - 3);
            sQuery = sQuery + " ) ";
        } else {
            sQuery = "(type:\"workitem\" AND $creator:\"" + this.loginController.getRemoteUser() + "\")";
        }
        return sQuery;
    }

    public String getCookie(String name) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        Cookie cookie = null;
        Cookie[] userCookies = request.getCookies();
        if (userCookies != null && userCookies.length > 0) {
            for (int i = 0; i < userCookies.length; ++i) {
                if (!userCookies[i].getName().equals(name)) continue;
                cookie = userCookies[i];
                return cookie.getValue();
            }
        }
        return null;
    }
}

