/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.AccessDeniedException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class ConfigService {
    int DEFAULT_CACHE_SIZE = 30;
    @EJB
    private DocumentService documentService;
    private Cache cache = null;
    final String TYPE = "configuration";

    @PostConstruct
    void init() {
        this.cache = new Cache(this.DEFAULT_CACHE_SIZE);
    }

    public ItemCollection createConfiguration(String name) throws Exception {
        ItemCollection configItemCollection = new ItemCollection();
        configItemCollection.replaceItemValue("type", (Object)"configuration");
        configItemCollection.replaceItemValue("txtname", (Object)name);
        configItemCollection.replaceItemValue("$writeAccess", (Object)"org.imixs.ACCESSLEVEL.MANAGERACCESS");
        configItemCollection.replaceItemValue("$readAccess", (Object)"");
        this.cache.put(name, configItemCollection);
        return configItemCollection;
    }

    public void deleteConfiguration(ItemCollection aconfig) throws AccessDeniedException {
        this.cache.remove(aconfig.getItemValueString("txtName"));
        this.documentService.remove(aconfig);
    }

    public ItemCollection loadConfiguration(String name) {
        return this.loadConfiguration(name, false);
    }

    public ItemCollection loadConfiguration(String name, boolean discardCache) {
        ItemCollection configItemCollection = null;
        configItemCollection = (ItemCollection)this.cache.get(name);
        if (configItemCollection == null || discardCache) {
            List col = this.documentService.getDocumentsByType("configuration");
            for (ItemCollection config : col) {
                if (!config.getItemValueString("txtname").equals(name)) continue;
                configItemCollection = config;
                break;
            }
            if (configItemCollection == null) {
                configItemCollection = new ItemCollection();
                configItemCollection.replaceItemValue("type", (Object)"configuration");
                configItemCollection.replaceItemValue("txtname", (Object)name);
            }
            this.cache.put(name, configItemCollection);
        }
        return configItemCollection;
    }

    public ItemCollection save(ItemCollection configItemCollection) throws AccessDeniedException {
        int version = configItemCollection.getItemValueInteger("$version");
        configItemCollection.replaceItemValue("type", (Object)"configuration");
        configItemCollection = this.documentService.save(configItemCollection);
        if (!configItemCollection.hasItem("$version")) {
            configItemCollection.setItemValue("$version", (Object)(++version));
        }
        this.cache.put(configItemCollection.getItemValueString("txtName"), configItemCollection);
        return configItemCollection;
    }

    public List<ItemCollection> findAllConfigurations() {
        ArrayList<ItemCollection> configList = new ArrayList<ItemCollection>();
        List col = this.documentService.getDocumentsByType("configuration");
        for (ItemCollection aworkitem : col) {
            configList.add(aworkitem);
        }
        Collections.sort(configList, new ItemCollectionComparator("txtname", true));
        return configList;
    }

    class Cache
    extends ConcurrentHashMap<String, ItemCollection>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int capacity;

        public Cache(int capacity) {
            super(capacity + 1, 1.1f);
            this.capacity = capacity;
        }

        protected boolean removeEldestEntry(Map.Entry<String, ItemCollection> eldest) {
            return this.size() > this.capacity;
        }
    }
}

