/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.config;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.SessionContext;
import javax.ejb.Singleton;
import javax.enterprise.event.Observes;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentEvent;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.TextEvent;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.util.XMLParser;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class TextBlockService {
    int DEFAULT_CACHE_SIZE = 30;
    @EJB
    private DocumentService documentService;
    @EJB
    private WorkflowService workflowService;
    @Resource
    SessionContext ctx;
    private Cache cache = null;
    final String TYPE = "textblock";
    private static Logger logger = Logger.getLogger(TextBlockService.class.getName());

    @PostConstruct
    void init() {
        this.cache = new Cache(this.DEFAULT_CACHE_SIZE);
    }

    public void deleteTextBlock(ItemCollection aconfig) throws AccessDeniedException {
        this.cache.remove(aconfig.getItemValueString("txtName"));
        this.documentService.remove(aconfig);
    }

    public ItemCollection loadTextBlock(String name) {
        return this.loadTextBlock(name, false);
    }

    public ItemCollection loadTextBlock(String name, boolean discardCache) {
        ItemCollection textBlockItemCollection = null;
        textBlockItemCollection = (ItemCollection)this.cache.get(name);
        if (textBlockItemCollection == null || discardCache) {
            textBlockItemCollection = this.documentService.load(name);
            if (textBlockItemCollection == null) {
                String sQuery = "(type:\"textblock\" AND txtname:\"" + name + "\")";
                try {
                    List col = this.documentService.find(sQuery, 1, 0);
                    if (col.size() > 0) {
                        textBlockItemCollection = (ItemCollection)col.iterator().next();
                    } else {
                        logger.warning("Missing text-block : '" + name + "'");
                    }
                }
                catch (QueryException e) {
                    logger.warning("getTextBlock - invalid query: " + e.getMessage());
                }
            }
            if (textBlockItemCollection == null) {
                textBlockItemCollection = new ItemCollection();
                textBlockItemCollection.replaceItemValue("type", (Object)"textblock");
                textBlockItemCollection.replaceItemValue("txtname", (Object)name);
            }
            this.cache.put(name, textBlockItemCollection);
        }
        return textBlockItemCollection;
    }

    public ItemCollection save(ItemCollection textBlockItemCollection) throws AccessDeniedException {
        if (textBlockItemCollection == null) {
            return textBlockItemCollection;
        }
        textBlockItemCollection.replaceItemValue("type", (Object)"textblock");
        textBlockItemCollection.replaceItemValue("$writeAccess", (Object)"org.imixs.ACCESSLEVEL.MANAGERACCESS");
        textBlockItemCollection.replaceItemValue("$readAccess", (Object)"");
        textBlockItemCollection.replaceItemValue("txtname", (Object)textBlockItemCollection.getItemValueString("txtName").trim());
        textBlockItemCollection.replaceItemValue("$Editor", (Object)this.ctx.getCallerPrincipal().getName().toString());
        textBlockItemCollection.replaceItemValue("namcurrentEditor", (Object)this.ctx.getCallerPrincipal().getName().toString());
        textBlockItemCollection = this.documentService.save(textBlockItemCollection);
        this.cache.put(textBlockItemCollection.getItemValueString("txtName"), textBlockItemCollection);
        return textBlockItemCollection;
    }

    public void onTextEvent(@Observes @Priority(value=2600) TextEvent event) {
        Object text = event.getText();
        if (((String)text).contains("<textBlock") || ((String)text).contains("</textBlock>")) {
            logger.warning("Deprecated <textBlock> tag should be lowercase <textblock> !");
            text = ((String)text).replace("<textBlock", "<textblock");
            text = ((String)text).replace("</textBlock>", "</textblock>");
        }
        List tagList = XMLParser.findTags((String)text, (String)"textblock");
        logger.finest(tagList.size() + " tags found");
        for (String tag : tagList) {
            String sTextBlockKey = XMLParser.findTagValue((String)tag, (String)"textblock");
            ItemCollection textBlockItemCollection = this.loadTextBlock(sTextBlockKey);
            if (textBlockItemCollection != null) {
                String sValue = "";
                if ("FILE".equals(textBlockItemCollection.getItemValueString("txtmode"))) {
                    List files = textBlockItemCollection.getFileNames();
                    if (files != null && files.size() > 0) {
                        sValue = (String)files.get(0);
                    }
                    if (files.size() > 1) {
                        logger.warning("textblock '" + sTextBlockKey + "' contains more than one file!");
                    }
                    if (sValue.trim().isEmpty()) {
                        logger.warning("textblock '" + sTextBlockKey + "' type FILE contains no file!");
                        sValue = " - missing file - ";
                    }
                } else {
                    sValue = textBlockItemCollection.getItemValueString("txtcontent");
                }
                int iStartPos = ((String)text).indexOf(tag);
                int iEndPos = ((String)text).indexOf(tag) + tag.length();
                try {
                    sValue = this.workflowService.adaptText(sValue, event.getDocument());
                }
                catch (PluginException e) {
                    logger.warning("Unable to adapt text within textblock '" + sTextBlockKey + "' : " + e.getMessage());
                }
                text = ((String)text).substring(0, iStartPos) + sValue + ((String)text).substring(iEndPos);
                continue;
            }
            logger.warning("text-block '" + sTextBlockKey + "' is not defined!");
        }
        event.setText((String)text);
    }

    public void onDocumentEvent(@Observes DocumentEvent event) {
        if ("textblock".equals(event.getDocument().getType()) && (event.getEventType() == 1 || event.getEventType() == 3)) {
            this.cache = new Cache(this.DEFAULT_CACHE_SIZE);
        }
    }

    class Cache
    extends ConcurrentHashMap<String, ItemCollection>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int capacity;

        public Cache(int capacity) {
            super(capacity + 1, 1.1f);
            this.capacity = capacity;
        }

        protected boolean removeEldestEntry(Map.Entry<String, ItemCollection> eldest) {
            return this.size() > this.capacity;
        }
    }
}

