/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.inject.Named;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.faces.data.WorkflowEvent;

@Named
@RequestScoped
public class CommentLogHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(CommentLogHandler.class.getName());

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) throws AccessDeniedException {
        if (21 == workflowEvent.getEventType() && workflowEvent.getWorkitem().hasItem("txtCommentLog")) {
            this.convertCommentLog(workflowEvent.getWorkitem());
        }
    }

    private void convertCommentLog(ItemCollection workitem) {
        if (workitem == null) {
            return;
        }
        List currentList = workitem.getItemValue("txtCommentLog");
        for (Map comment : currentList) {
            Object text;
            Object editor;
            Object date = comment.get("datcomment");
            if (date instanceof List) {
                logger.warning("...Comment Log: date object is of type: " + date.getClass().getName() + " - data type will be fixed on next save event.");
                comment.put("datcomment", ((List)date).get(0));
            }
            if ((editor = comment.get("nameditor")) instanceof List) {
                logger.warning("...Comment Log: nameditor object is of type: " + editor.getClass().getName() + " - data type will be fixed on next save event.");
                comment.put("nameditor", ((List)editor).get(0));
            }
            if (!((text = comment.get("txtcomment")) instanceof List)) continue;
            logger.warning("...Comment Log: nameditor object is of type: " + text.getClass().getName() + " - data type will be fixed on next save event.");
            comment.put("txtcomment", ((List)text).get(0));
        }
    }
}

