/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.TextEvent;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.util.XMLParser;

@Stateless
public class CountryAdapter {
    private static Logger logger = Logger.getLogger(AbstractPlugin.class.getName());

    public void onEvent(@Observes TextEvent event) {
        Object text = event.getText();
        ItemCollection documentContext = event.getDocument();
        List tagList = XMLParser.findTags((String)text, (String)"countryname");
        logger.finest(tagList.size() + " tags found");
        for (String tag : tagList) {
            Locale locale = null;
            String sLocale = XMLParser.findAttribute((String)tag, (String)"locale");
            if (sLocale == null || sLocale.isEmpty()) {
                logger.info("...no locale defined - default to en_EN");
                sLocale = "en_EN";
            }
            String separator = XMLParser.findAttribute((String)tag, (String)"separator");
            if (sLocale != null && !sLocale.isEmpty()) {
                String sLang;
                StringTokenizer stLocale = new StringTokenizer(sLocale, "_");
                if (stLocale.countTokens() == 1) {
                    sLang = stLocale.nextToken();
                    String sCount = sLang.toUpperCase();
                    locale = new Locale(sLang, sCount);
                } else {
                    sLang = stLocale.nextToken();
                    String sCount = stLocale.nextToken();
                    locale = new Locale(sLang, sCount);
                }
            }
            String sItemName = XMLParser.findTagValue((String)tag, (String)"countryname");
            Object country = "";
            if (separator == null || separator.isEmpty()) {
                String countryCode = documentContext.getItemValueString(sItemName);
                Locale countryLocale = new Locale("", countryCode);
                if (countryLocale != null) {
                    country = countryLocale.getDisplayCountry(locale);
                }
            } else {
                List countryCodes = documentContext.getItemValue(sItemName);
                for (String countryCode : countryCodes) {
                    Locale countryLocale = new Locale("", countryCode);
                    country = (String)country + countryLocale.getDisplayCountry(locale);
                    country = (String)country + separator;
                }
                if (((String)country).endsWith(separator)) {
                    country = ((String)country).substring(0, ((String)country).length() - separator.length());
                }
            }
            int iStartPos = ((String)text).indexOf(tag);
            int iEndPos = ((String)text).indexOf(tag) + tag.length();
            text = ((String)text).substring(0, iStartPos) + (String)country + ((String)text).substring(iEndPos);
        }
        event.setText((String)text);
    }
}

