/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.faces.model.SelectItem;
import javax.inject.Inject;
import javax.inject.Named;
import org.imixs.marty.profile.UserController;

@Named
@RequestScoped
public class CountryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(CountryController.class.getName());
    @Inject
    UserController userController;
    Comparator<SelectItem> selectItemComparator = new Comparator<SelectItem>(){

        @Override
        public int compare(SelectItem s1, SelectItem s2) {
            Collator collator = Collator.getInstance(CountryController.this.userController.getLocale());
            collator.setStrength(1);
            return collator.compare(s1.getLabel(), s2.getLabel());
        }
    };

    public List<SelectItem> getCountriesSelectItems() {
        ArrayList<SelectItem> selection = new ArrayList<SelectItem>();
        String[] locales = Locale.getISOCountries();
        logger.fine("...found " + locales.length + " countries");
        for (String countryCode : locales) {
            Locale locale = new Locale("", countryCode);
            String code = locale.getCountry();
            String country = locale.getDisplayCountry(this.userController.getLocale());
            selection.add(new SelectItem((Object)code, country + " (" + code + ")"));
        }
        Collections.sort(selection, this.selectItemComparator);
        return selection;
    }

    public String getCountryName(String countryCode) {
        Locale countryLocale = new Locale("", countryCode);
        return countryLocale.getDisplayCountry(this.userController.getLocale());
    }

    public String getCountryNames(List<String> countryCodes) {
        Object result = "";
        for (String countryCode : countryCodes) {
            Locale countryLocale = new Locale("", countryCode);
            result = (String)result + countryLocale.getDisplayCountry(this.userController.getLocale()) + ", ";
        }
        result = ((String)result).substring(0, ((String)result).length() - 2);
        return result;
    }
}

