/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.event.Observes;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.faces.data.WorkflowEvent;
import org.imixs.workflow.office.forms.CustomFormItem;
import org.imixs.workflow.office.forms.CustomFormSection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Named
@ConversationScoped
public class CustomFormController
implements Serializable {
    @EJB
    ModelService modelService;
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(CustomFormController.class.getName());
    private List<CustomFormSection> sections;
    private String supportedExpressions = "";

    public CustomFormController() {
        this.loadCustomFormExpressions();
    }

    public List<CustomFormSection> getSections() {
        return this.sections;
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) throws ModelException {
        if (workflowEvent == null) {
            return;
        }
        if (workflowEvent.getWorkitem() != null && !workflowEvent.getWorkitem().getItemValueString("type").startsWith("workitem")) {
            return;
        }
        int eventType = workflowEvent.getEventType();
        if (21 == eventType || 20 == eventType || 23 == eventType) {
            this.computeFieldDefinition(workflowEvent.getWorkitem());
        }
    }

    public void computeFieldDefinition(ItemCollection workitem) throws ModelException {
        this.sections = new ArrayList<CustomFormSection>();
        String content = this.fetchFormDefinitionFromModel(workitem);
        if (content.isEmpty()) {
            content = workitem.getItemValueString("txtWorkflowEditorCustomForm");
        }
        if (!content.isEmpty()) {
            logger.finest("......start parsing custom form definition");
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
                Document doc = builder.parse(stream);
                doc.getDocumentElement().normalize();
                NodeList nList = doc.getElementsByTagName("imixs-form-section");
                for (int temp = 0; temp < nList.getLength(); ++temp) {
                    Node nNode = nList.item(temp);
                    logger.finest("parsing section...");
                    if (nNode.getNodeType() != 1) continue;
                    Element eElement = (Element)nNode;
                    String sReadOnly = eElement.getAttribute("readonly");
                    boolean bReadOnly = false;
                    if (sReadOnly != null && !sReadOnly.isEmpty()) {
                        bReadOnly = Boolean.parseBoolean(sReadOnly);
                    }
                    CustomFormSection customSection = new CustomFormSection(eElement.getAttribute("label"), eElement.getAttribute("columns"), eElement.getAttribute("path"), bReadOnly);
                    customSection.setItems(this.findItems(eElement));
                    this.sections.add(customSection);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.warning("Unable to parse custom form definition: " + e.getMessage());
                return;
            }
            workitem.replaceItemValue("txtWorkflowEditorCustomForm", (Object)content);
        }
    }

    private String fetchFormDefinitionFromModel(ItemCollection workitem) {
        ItemCollection task;
        try {
            Model model = this.modelService.getModelByWorkitem(workitem);
            task = model.getTask(workitem.getTaskID());
        }
        catch (ModelException e) {
            logger.warning("unable to parse data object in model: " + e.getMessage());
            return "";
        }
        List dataObjects = task.getItemValue("dataObjects");
        for (List dataObject : dataObjects) {
            String templateName = (String)dataObject.get(0);
            String content = (String)dataObject.get(1);
            if (!content.contains("<imixs-form>")) continue;
            logger.finest("......DataObject name=" + templateName);
            logger.finest("......DataObject content=" + content);
            return content;
        }
        return "";
    }

    private List<CustomFormItem> findItems(Element sectionElement) throws ModelException {
        ArrayList<CustomFormItem> result = new ArrayList<CustomFormItem>();
        NodeList itemList = sectionElement.getElementsByTagName("item");
        for (int temp = 0; temp < itemList.getLength(); ++temp) {
            Node itemNode = itemList.item(temp);
            logger.finest("......parsing item...");
            if (itemNode.getNodeType() != 1) continue;
            Element itemElement = (Element)itemNode;
            CustomFormItem customItem = new CustomFormItem(itemElement.getAttribute("name"), itemElement.getAttribute("type"), itemElement.getAttribute("label"), this.evaluateBoolean(itemElement.getAttribute("required")), this.evaluateBoolean(itemElement.getAttribute("readonly")), itemElement.getAttribute("options"), itemElement.getAttribute("path"), this.evaluateBoolean(itemElement.getAttribute("hide")));
            result.add(customItem);
        }
        return result;
    }

    private boolean evaluateBoolean(String expression) throws ModelException {
        if (expression == null || expression.isEmpty()) {
            return false;
        }
        if (expression.startsWith("#{") && expression.endsWith("}")) {
            if (this.supportedExpressions.contains(expression)) {
                FacesContext ctx = FacesContext.getCurrentInstance();
                Application app = ctx.getApplication();
                boolean result = (Boolean)app.evaluateExpressionGet(ctx, expression, Boolean.class);
                return result;
            }
            throw new ModelException("INVALID_MODEL_ENTRY", "The custom-form expression is not allowed: " + expression);
        }
        return Boolean.parseBoolean(expression);
    }

    private void loadCustomFormExpressions() {
        block9: {
            try {
                StringBuilder resultStringBuilder = new StringBuilder();
                try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getFileFromResourceAsStream("customform.expressions")));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        resultStringBuilder.append(line).append("\n");
                    }
                }
                this.supportedExpressions = resultStringBuilder.toString();
            }
            catch (Exception e) {
                logger.warning("unable to find customform.expressions in current classpath");
                if (!logger.isLoggable(Level.FINE)) break block9;
                e.printStackTrace();
            }
        }
    }

    private InputStream getFileFromResourceAsStream(String fileName) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new IllegalArgumentException("file not found! " + fileName);
        }
        return inputStream;
    }
}

