/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.context.RequestScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.office.util.WorkitemHelper;

@Named
@RequestScoped
public class WorkitemLinkController
implements Serializable {
    public static final String LINK_PROPERTY = "$workitemref";
    public static final String LINK_PROPERTY_DEPRECATED = "txtworkitemref";
    public static final int MAX_SEARCH_RESULT = 20;
    public static Logger logger = Logger.getLogger(WorkitemLinkController.class.getName());
    @EJB
    protected WorkflowService workflowService;
    @EJB
    protected SchemaService schemaService;
    @Inject
    protected WorkflowController workflowController;
    private static final long serialVersionUID = 1L;
    private List<ItemCollection> searchResult = new ArrayList<ItemCollection>();

    public void searchWorkitems() {
        this.searchResult = new ArrayList<ItemCollection>();
        FacesContext fc = FacesContext.getCurrentInstance();
        String phrase = (String)fc.getExternalContext().getRequestParameterMap().get("phrase");
        String options = (String)fc.getExternalContext().getRequestParameterMap().get("options");
        if (phrase == null) {
            return;
        }
        logger.finest("......workitemLink search prase '" + phrase + "'  options=" + options);
        this.searchResult = this.searchWorkitems(phrase, options);
        if (this.searchResult != null) {
            logger.finest("found " + this.searchResult.size() + " user profiles...");
        }
    }

    public List<ItemCollection> searchWorkitems(String phrase, String filter) {
        ArrayList<ItemCollection> searchResult = new ArrayList<ItemCollection>();
        logger.finest(".......search workitem links : " + phrase);
        if (phrase == null || phrase.isEmpty()) {
            return searchResult;
        }
        List col = null;
        try {
            phrase = phrase.trim().toLowerCase();
            phrase = this.schemaService.escapeSearchTerm(phrase);
            phrase = this.schemaService.normalizeSearchTerm(phrase);
            Object sQuery = "";
            sQuery = (String)sQuery + "((type:workitem) OR (type:workitemarchive)) AND  (*" + phrase + "*)";
            if (filter != null && !"".equals(filter.trim())) {
                String sNewFilter = filter.trim().replace(".", "?");
                sQuery = (String)sQuery + " AND (" + sNewFilter + ") ";
            }
            logger.finest("......query=" + (String)sQuery);
            col = this.workflowService.getDocumentService().find((String)sQuery, 20, 0);
            if (col != null) {
                for (ItemCollection aWorkitem : col) {
                    searchResult.add(WorkitemHelper.clone(aWorkitem));
                }
                Collections.sort(searchResult, new ItemCollectionComparator("$workflowabstract", true));
            }
        }
        catch (Exception e) {
            logger.warning("Lucene error error: " + e.getMessage());
        }
        return searchResult;
    }

    public List<ItemCollection> getSearchResult() {
        return this.searchResult;
    }

    public List<ItemCollection> getReferences() {
        return this.getReferences("");
    }

    public List<ItemCollection> getReferences(String filter) {
        long l = System.currentTimeMillis();
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        if (this.workflowController.getWorkitem() == null) {
            return result;
        }
        logger.finest("......lookup references for: " + filter);
        List refList = null;
        refList = !this.workflowController.getWorkitem().hasItem(LINK_PROPERTY) && this.workflowController.getWorkitem().hasItem(LINK_PROPERTY_DEPRECATED) ? this.workflowController.getWorkitem().getItemValue(LINK_PROPERTY_DEPRECATED) : this.workflowController.getWorkitem().getItemValue(LINK_PROPERTY);
        if (refList != null && !refList.isEmpty()) {
            logger.finest("... we have " + refList.size() + " references stored");
            Object sQuery = "(";
            for (String ref : refList) {
                if (ref == null || ref.trim().isEmpty()) continue;
                sQuery = (String)sQuery + "$uniqueid:\"" + ref + "\" OR ";
            }
            if (!((String)sQuery).contains("$uniqueid")) {
                return result;
            }
            if (((String)sQuery).endsWith("OR ")) {
                sQuery = ((String)sQuery).substring(0, ((String)sQuery).lastIndexOf("OR "));
            }
            sQuery = (String)sQuery + ")";
            if (filter != null && !"".equals(filter.trim())) {
                String sNewFilter = filter.trim().replace(".", "?");
                sQuery = (String)sQuery + " AND (" + sNewFilter + ") ";
            }
            logger.finest("......query=" + (String)sQuery);
            List workitems = null;
            try {
                workitems = this.workflowService.getDocumentService().findStubs((String)sQuery, 20, 0, "$created", true);
            }
            catch (QueryException e) {
                e.printStackTrace();
            }
            if (workitems != null) {
                result.addAll(workitems);
            }
        }
        logger.fine("...lookup references for: " + filter + " in " + (System.currentTimeMillis() - l) + "ms");
        return result;
    }

    public List<ItemCollection> getExternalReferences() {
        return this.getExternalReferences("");
    }

    public List<ItemCollection> getExternalReferences(String filter) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        if (this.workflowController.getWorkitem() == null) {
            return result;
        }
        String uniqueid = this.workflowController.getWorkitem().getUniqueID();
        if ("".equals(uniqueid)) {
            return result;
        }
        Object sQuery = "(";
        sQuery = " (type:\"workitem\" OR type:\"workitemarchive\") AND ($workitemref:\"" + uniqueid + "\"  OR txtworkitemref:\"" + uniqueid + "\")";
        List workitems = null;
        try {
            workitems = this.workflowService.getDocumentService().findStubs((String)sQuery, 20, 0, "$lasteventdate", true);
        }
        catch (QueryException e) {
            e.printStackTrace();
        }
        Collections.sort(workitems, new ItemCollectionComparator("$created", true));
        if (filter != null && !filter.isEmpty()) {
            for (ItemCollection itemcol : workitems) {
                if (!WorkitemHelper.matches(itemcol, filter)) continue;
                result.add(itemcol);
            }
        } else {
            result.addAll(workitems);
        }
        return result;
    }

    public ItemCollection getWorkitem(String id) {
        return this.workflowService.getWorkItem(id);
    }
}

