/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.rest;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.imixs.marty.profile.ProfileService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.index.Category;
import org.imixs.workflow.engine.index.SearchService;

@Stateless
@Produces(value={"text/html", "application/xhtml+xml", "application/xml", "application/json", "text/xml"})
@Path(value="/monitor")
public class MonitorRestService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    SearchService searchService;
    @Inject
    ProfileService profileService;
    @EJB
    DocumentService documentService;
    private static Logger logger = Logger.getLogger(MonitorRestService.class.getName());

    @GET
    @Path(value="/{processid}/{workflowgroup}/{task}/{category}")
    @Produces(value={"application/json", "application/xhtml+xml"})
    public String taxonomyChartData(@PathParam(value="processid") String processid, @PathParam(value="workflowgroup") String workflowgroup, @PathParam(value="task") String task, @PathParam(value="category") String category) {
        logger.finest("taxonomy computing: " + workflowgroup + " " + task);
        String query = "(type:workitem AND $uniqueidref:" + processid + " AND $workflowgroup:\"" + workflowgroup + "\" AND $workflowstatus:\"" + task + "\")";
        logger.finest(query);
        List taxResult = this.searchService.getTaxonomyByQuery(query, new String[]{category});
        Object result = "{";
        if (taxResult.size() > 0) {
            String name;
            String id;
            Iterator iterator;
            Category cat = (Category)taxResult.get(0);
            Map labelMap = cat.getLabels();
            ArrayList<String> labels = new ArrayList<String>();
            if ("$owner".equals(category) || "$creator".equals(category) || "$editor".equals(category)) {
                iterator = labelMap.keySet().iterator();
                while (iterator.hasNext()) {
                    name = id = (String)iterator.next();
                    ItemCollection profile = this.profileService.findProfileById(id);
                    if (profile != null && (name = profile.getItemValueString("txtusername")).isEmpty()) {
                        name = id;
                    }
                    labels.add(name);
                }
            } else if ("space.ref".equals(category)) {
                iterator = labelMap.keySet().iterator();
                while (iterator.hasNext()) {
                    name = id = (String)iterator.next();
                    ItemCollection space = this.documentService.load(id);
                    if (space != null && (name = space.getItemValueString("name")).isEmpty()) {
                        name = id;
                    }
                    labels.add(name);
                }
            } else {
                labels.addAll(labelMap.keySet());
            }
            result = (String)result + "\"labels\" : [ ";
            result = (String)result + labels.stream().collect(Collectors.joining("\",\"", "\"", "\""));
            result = (String)result + "],";
            result = (String)result + "\"origins\" : [ ";
            result = (String)result + labelMap.keySet().stream().collect(Collectors.joining("\",\"", "\"", "\""));
            result = (String)result + "],";
            result = (String)result + "\"datasets\": [{";
            result = (String)result + "\"label\": \"By Category\",";
            result = (String)result + "\"data\" : [ ";
            ArrayList<CallSite> valueList = new ArrayList<CallSite>();
            for (Integer dat : labelMap.values()) {
                valueList.add((CallSite)((Object)("" + dat)));
            }
            result = (String)result + valueList.stream().collect(Collectors.joining(",", "", ""));
            result = (String)result + "],";
        } else {
            result = (String)result + "\"labels\" : [ ],";
            result = (String)result + "\"datasets\": [{";
            result = (String)result + "\"label\": \"By Category\",";
            result = (String)result + "\"data\" : [ ],";
        }
        result = (String)result + MonitorRestService.generateBackgroundColorScheme();
        result = (String)result + "}]}";
        for (Category cat : taxResult) {
            logger.finest("cat: " + cat.getName() + " = " + cat.getCount());
            Map labelMap = cat.getLabels();
            labelMap.forEach((key, value) -> logger.finest("   " + key + " : " + value));
        }
        logger.finest("result=" + (String)result);
        return result;
    }

    public static String generateBackgroundColorScheme() {
        String result = " \"backgroundColor\" : [\n   \"#3B6B82\",\"#70B088\",\"#EBA05F\",\"#9B3425\",\"#CFE9F5\",\"#F1D437\",\"#E73B65\",\"#462645\",\"#2D6CA8\",\"#2B5C33\",\"#F28E1C\",\"#F3E500\" ]";
        return result;
    }
}

