/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.config;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.office.config.PropertyController;

@Named
@RequestScoped
public class SpaceController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    protected WorkflowController workflowController;
    @Inject
    WorkflowService workflowService;
    @Inject
    protected PropertyController propertyController;
    private static Logger logger = Logger.getLogger(SpaceController.class.getName());

    public void create(String parentID) throws ModelException {
        if (parentID != null && !parentID.isEmpty()) {
            ItemCollection parentSpace = this.workflowService.getWorkItem(parentID);
            if (parentSpace != null) {
                this.workflowController.create(this.propertyController.getProperty("setup.system.model"), 100, parentID);
                this.workflowController.getWorkitem().setItemValue("space.parent.name", (Object)parentSpace.getItemValueString("name"));
            } else {
                logger.warning("Can not create subspace - space " + parentID + " not found!");
            }
        } else {
            this.workflowController.create(this.propertyController.getProperty("setup.system.model"), 100, null);
        }
    }
}

