/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.faces.data.WorkflowEvent;
import org.imixs.workflow.office.forms.ChronicleEntity;
import org.imixs.workflow.office.forms.ChronicleEntityComparator;
import org.imixs.workflow.office.forms.DMSController;
import org.imixs.workflow.office.forms.WorkitemLinkController;
import org.imixs.workflow.office.forms.WorkitemService;

@Named
@ConversationScoped
public class ChronicleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    protected WorkflowController workflowController;
    private static Logger logger = Logger.getLogger(ChronicleController.class.getName());
    List<ChronicleEntity> originChronicleList;
    List<ChronicleEntity> filteredChronicleList;
    String filter = null;
    Map<Integer, Set<Integer>> yearsMonths;
    @Inject
    protected DMSController dmsController;
    @Inject
    protected WorkitemLinkController workitemLinkController;
    @EJB
    protected WorkitemService workitemService;
    @EJB
    protected DocumentService documentService;
    private DateFormat dateFormat = null;

    @PostConstruct
    public void init() {
        Date date;
        long l = System.currentTimeMillis();
        this.originChronicleList = new ArrayList<ChronicleEntity>();
        this.yearsMonths = new HashMap<Integer, Set<Integer>>();
        try {
            Locale browserLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            ResourceBundle rb = ResourceBundle.getBundle("bundle.messages", browserLocale);
            String sDatePattern = rb.getString("dateTimePattern");
            this.dateFormat = new SimpleDateFormat(sDatePattern);
        }
        catch (MissingResourceException mre) {
            this.dateFormat = null;
        }
        List history = this.workflowController.getWorkitem().getItemValue("txtworkflowhistory");
        Collections.reverse(history);
        if (history.size() > 0 && history.get(0) instanceof List) {
            for (Object entries : history) {
                Date date2 = (Date)entries.get(0);
                String message = (String)entries.get(1);
                String user = (String)entries.get(2);
                ItemCollection entry = new ItemCollection();
                entry.replaceItemValue("date", (Object)date2);
                entry.replaceItemValue("user", (Object)user);
                entry.replaceItemValue("message", (Object)message);
                entry.replaceItemValue("type", (Object)"history");
                this.addChronicleEntry(this.originChronicleList, entry);
            }
        }
        List comments = this.workflowController.getWorkitem().getItemValue("txtCommentLog");
        for (Object comment : comments) {
            ItemCollection itemCol = new ItemCollection((Map)comment);
            Date date3 = itemCol.getItemValueDate("datcomment");
            String message = itemCol.getItemValueString("txtcomment");
            String user = itemCol.getItemValueString("nameditor");
            ItemCollection entry = new ItemCollection();
            entry.replaceItemValue("date", (Object)date3);
            entry.replaceItemValue("user", (Object)user);
            entry.replaceItemValue("message", (Object)message);
            entry.replaceItemValue("type", (Object)"comment");
            this.addChronicleEntry(this.originChronicleList, entry);
        }
        List<ItemCollection> dmsList = this.dmsController.getDmsList();
        for (ItemCollection dmsEntry : dmsList) {
            ItemCollection entry = new ItemCollection(dmsEntry);
            String user = entry.getItemValueString("$creator");
            date = null;
            if (dmsEntry.getItemValueDate("$modified") != null) {
                date = dmsEntry.getItemValueDate("$modified");
                user = entry.getItemValueString("$editor");
            } else {
                date = dmsEntry.getItemValueDate("$created");
            }
            if (date == null) {
                date = new Date();
            }
            entry.replaceItemValue("date", (Object)date);
            entry.replaceItemValue("type", (Object)"dms");
            entry.replaceItemValue("user", (Object)user);
            this.addChronicleEntry(this.originChronicleList, entry);
        }
        List<ItemCollection> references = this.workitemLinkController.getReferences();
        List<ItemCollection> externalReferences = this.workitemLinkController.getExternalReferences();
        for (ItemCollection _workitem : externalReferences) {
            if (this.containsUniqueID(references, _workitem.getUniqueID())) continue;
            references.add(_workitem);
        }
        for (ItemCollection reference : references) {
            date = reference.getItemValueDate("$created");
            Object message = reference.getItemValueString("$WorkflowSummary");
            if (((String)message).isEmpty()) {
                message = this.dateFormat == null ? (String)message + date.toString() : (String)message + this.dateFormat.format(date);
            }
            String user = reference.getItemValueString("$creator");
            ItemCollection entry = new ItemCollection();
            entry.replaceItemValue("$WorkflowGroup", (Object)reference.getItemValue("$WorkflowGroup"));
            entry.replaceItemValue("$WorkflowStatus", (Object)reference.getItemValue("$WorkflowStatus"));
            entry.replaceItemValue("$lasteventdate", (Object)reference.getItemValue("$lasteventdate"));
            entry.replaceItemValue("date", (Object)date);
            entry.replaceItemValue("user", (Object)user);
            entry.replaceItemValue("$lasteditor", (Object)reference.getItemValueString("$editor"));
            entry.replaceItemValue("message", message);
            entry.replaceItemValue("type", (Object)"reference");
            entry.replaceItemValue("$uniqueid", (Object)reference.getUniqueID());
            this.addChronicleEntry(this.originChronicleList, entry);
        }
        List<ItemCollection> versions = this.workitemService.findAllVersions(this.workflowController.getWorkitem());
        for (ItemCollection version : versions) {
            if (this.workflowController.getWorkitem().getUniqueID().equals(version.getUniqueID())) continue;
            ItemCollection versionFull = this.documentService.load(version.getUniqueID());
            Date date4 = version.getItemValueDate("$created");
            String message = version.getItemValueString("$WorkflowSummary");
            String user = version.getItemValueString("$editor");
            ItemCollection entry = new ItemCollection();
            entry.replaceItemValue("$WorkflowGroup", (Object)version.getItemValue("$WorkflowGroup"));
            entry.replaceItemValue("$WorkflowStatus", (Object)version.getItemValue("$WorkflowStatus"));
            entry.replaceItemValue("$lasteventdate", (Object)version.getItemValue("$lasteventdate"));
            entry.replaceItemValue("user", (Object)user);
            if (!versionFull.getItemValueString("$uniqueIdSource").isEmpty()) {
                entry.replaceItemValue("message", (Object)message);
                entry.replaceItemValue("icon", (Object)"typcn-starburst-outline");
                if (versionFull.hasItem("$created.version")) {
                    date4 = versionFull.getItemValueDate("$created.version");
                }
            } else {
                entry.replaceItemValue("message", (Object)message);
                entry.replaceItemValue("icon", (Object)"typcn-starburst");
            }
            entry.replaceItemValue("date", (Object)date4);
            entry.replaceItemValue("type", (Object)"version");
            entry.replaceItemValue("$uniqueid", (Object)version.getUniqueID());
            this.addChronicleEntry(this.originChronicleList, entry);
        }
        Collections.sort(this.originChronicleList, new ChronicleEntityComparator(true));
        this.computeTimeData(this.originChronicleList);
        this.filteredChronicleList = new ArrayList<ChronicleEntity>();
        this.filteredChronicleList.addAll(this.originChronicleList);
        logger.fine("...init in " + (System.currentTimeMillis() - l) + "ms");
    }

    private boolean containsUniqueID(List<ItemCollection> list, String uniqueID) {
        for (ItemCollection workitem : list) {
            if (!workitem.getUniqueID().equals(uniqueID)) continue;
            return true;
        }
        return false;
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) {
        if (workflowEvent == null) {
            return;
        }
        if (20 == workflowEvent.getEventType() || 21 == workflowEvent.getEventType()) {
            this.init();
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public List<Integer> getYears() {
        Set<Integer> result = this.yearsMonths.keySet();
        ArrayList<Integer> sortedList = new ArrayList<Integer>(result);
        Collections.sort(sortedList);
        Collections.reverse(sortedList);
        return sortedList;
    }

    public List<Integer> getMonths(int year) {
        Set<Integer> result = this.yearsMonths.get(year);
        if (result == null) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> sortedList = new ArrayList<Integer>(result);
        Collections.sort(sortedList);
        Collections.reverse(sortedList);
        return sortedList;
    }

    public List<ChronicleEntity> getChroniclePerMonth(int year, int month) {
        ArrayList<ChronicleEntity> result = new ArrayList<ChronicleEntity>();
        for (ChronicleEntity entry : this.filteredChronicleList) {
            Date date = entry.getDate();
            LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            if (month != localDate.getMonthValue() || year != localDate.getYear()) continue;
            result.add(entry);
        }
        logger.finest("......getChroniclePerMonth - found " + result.size() + " chronicle entities");
        return result;
    }

    public void toggleFilter(String category) {
        long l = System.currentTimeMillis();
        logger.finest("......toggleFilter : " + category);
        this.filter = category != null && !category.isEmpty() && category.equals(this.filter) ? null : category;
        if (this.filter == null || this.filter.isEmpty()) {
            this.filteredChronicleList = new ArrayList<ChronicleEntity>();
            this.filteredChronicleList.addAll(this.originChronicleList);
        } else {
            this.filteredChronicleList = new ArrayList<ChronicleEntity>();
            for (ChronicleEntity chronicleEntry : this.originChronicleList) {
                List<ItemCollection> entries = chronicleEntry.getEntries();
                for (ItemCollection entry : entries) {
                    if (!this.filter.equals(entry.getType())) continue;
                    this.addChronicleEntry(this.filteredChronicleList, entry);
                }
            }
            Collections.sort(this.filteredChronicleList, new ChronicleEntityComparator(true));
        }
        this.computeTimeData(this.filteredChronicleList);
        logger.finest("......filter=" + this.filter + " size= " + this.filteredChronicleList.size());
        logger.fine("...computed filter in " + (System.currentTimeMillis() - l) + "ms");
    }

    private void addChronicleEntry(List<ChronicleEntity> chronicleList, ItemCollection entry) {
        String user = entry.getItemValueString("user");
        Date date = entry.getItemValueDate("date");
        LocalDateTime localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        date = Date.from((localDate = localDate.truncatedTo(ChronoUnit.MINUTES)).atZone(ZoneId.systemDefault()).toInstant());
        ChronicleEntity chronicleEntity = new ChronicleEntity(user, date);
        int chronicleIndex = chronicleList.indexOf(chronicleEntity);
        if (chronicleIndex > -1) {
            chronicleEntity = chronicleList.get(chronicleIndex);
        }
        chronicleEntity.addEntry(entry);
        if (chronicleIndex > -1) {
            chronicleList.set(chronicleIndex, chronicleEntity);
        } else {
            chronicleList.add(chronicleEntity);
        }
    }

    private void computeTimeData(List<ChronicleEntity> chronicleList) {
        this.yearsMonths = new HashMap<Integer, Set<Integer>>();
        for (ChronicleEntity chronicleEntity : chronicleList) {
            this.addTimeData(chronicleEntity.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        }
    }

    private void addTimeData(LocalDate localDate) {
        int year = localDate.getYear();
        int month = localDate.getMonthValue();
        Set<Integer> mothsPerYear = this.yearsMonths.get(year);
        if (mothsPerYear == null) {
            mothsPerYear = new HashSet<Integer>();
        }
        mothsPerYear.add(month);
        this.yearsMonths.put(year, mothsPerYear);
    }
}

