/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.ejb.EJB;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.faces.application.Application;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Named;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.faces.data.WorkflowEvent;
import org.imixs.workflow.office.forms.CustomFormItem;
import org.imixs.workflow.office.forms.CustomFormSection;
import org.imixs.workflow.office.forms.CustomSubForm;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Named
@ConversationScoped
public class CustomFormController
implements Serializable {
    @EJB
    ModelService modelService;
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(CustomFormController.class.getName());
    private List<CustomSubForm> subforms = null;
    private List<CustomFormSection> sections;
    private String supportedExpressions = "";

    public CustomFormController() {
        this.loadCustomFormExpressions();
    }

    public List<CustomSubForm> getSubforms() {
        return this.subforms;
    }

    public List<CustomFormSection> getSections() {
        return this.sections;
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) throws ModelException {
        if (workflowEvent == null) {
            return;
        }
        if (workflowEvent.getWorkitem() != null && !workflowEvent.getWorkitem().getItemValueString("type").startsWith("workitem")) {
            return;
        }
        int eventType = workflowEvent.getEventType();
        if (21 == eventType || 20 == eventType || 23 == eventType) {
            this.computeFieldDefinition(workflowEvent.getWorkitem());
        }
    }

    public void computeFieldDefinition(ItemCollection workitem) throws ModelException {
        this.sections = new ArrayList<CustomFormSection>();
        String content = this.fetchFormDefinitionFromModel(workitem);
        if (content.isEmpty()) {
            content = workitem.getItemValueString("txtWorkflowEditorCustomForm");
        }
        if (!content.isEmpty()) {
            logger.finest("......start parsing custom form definition");
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
                Document doc = builder.parse(stream);
                doc.getDocumentElement().normalize();
                Element rootElement = doc.getDocumentElement();
                NodeList nSubformList = rootElement.getElementsByTagName("imixs-subform");
                if (nSubformList != null && nSubformList.getLength() > 0) {
                    this.subforms = new ArrayList<CustomSubForm>();
                    for (int subId = 0; subId < nSubformList.getLength(); ++subId) {
                        Element nSubFormElement = (Element)nSubformList.item(subId);
                        String label = nSubFormElement.getAttribute("label");
                        String sReadOnly = nSubFormElement.getAttribute("readonly");
                        boolean bReadOnly = false;
                        if (sReadOnly != null && !sReadOnly.isEmpty()) {
                            bReadOnly = Boolean.parseBoolean(sReadOnly);
                        }
                        CustomSubForm customSubForm = new CustomSubForm("subform-" + (subId + 1), label, bReadOnly);
                        this.sections = this.parseSectionList(nSubFormElement, bReadOnly);
                        customSubForm.setSections(this.sections);
                        this.subforms.add(customSubForm);
                    }
                } else {
                    this.sections = this.parseSectionList(rootElement, false);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.warning("Unable to parse custom form definition: " + e.getMessage());
                return;
            }
            workitem.replaceItemValue("txtWorkflowEditorCustomForm", (Object)content);
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (this.getSubforms() == null || this.getSubforms().size() == 0) {
            for (CustomFormSection _section : this.getSections()) {
                _section.setReadonly(readOnly);
                for (CustomFormItem _item : _section.getItems()) {
                    _item.setReadonly(readOnly);
                }
            }
        } else {
            for (CustomSubForm _subform : this.getSubforms()) {
                for (CustomFormSection _section : _subform.getSections()) {
                    _section.setReadonly(readOnly);
                    for (CustomFormItem _item : _section.getItems()) {
                        _item.setReadonly(readOnly);
                    }
                }
            }
        }
    }

    private List<CustomFormSection> parseSectionList(Element parentNode, boolean readOnly) throws ModelException {
        ArrayList<CustomFormSection> result = new ArrayList<CustomFormSection>();
        boolean defaultReadOnly = false;
        NodeList nSectionList = parentNode.getElementsByTagName("imixs-form-section");
        for (int temp = 0; temp < nSectionList.getLength(); ++temp) {
            Node nSectionNode = nSectionList.item(temp);
            logger.finest("parsing section...");
            if (nSectionNode.getNodeType() != 1) continue;
            Element eSectionElement = (Element)nSectionNode;
            if (readOnly) {
                defaultReadOnly = true;
            } else {
                String sReadOnly = eSectionElement.getAttribute("readonly");
                defaultReadOnly = false;
                if (sReadOnly != null && !sReadOnly.isEmpty()) {
                    defaultReadOnly = Boolean.parseBoolean(sReadOnly);
                }
            }
            CustomFormSection customSection = new CustomFormSection(eSectionElement.getAttribute("label"), eSectionElement.getAttribute("columns"), eSectionElement.getAttribute("path"), defaultReadOnly);
            customSection.setItems(this.findItems(eSectionElement, customSection.getColumns(), defaultReadOnly));
            result.add(customSection);
        }
        return result;
    }

    private String fetchFormDefinitionFromModel(ItemCollection workitem) {
        ItemCollection task;
        try {
            Model model = this.modelService.getModelByWorkitem(workitem);
            task = model.getTask(workitem.getTaskID());
        }
        catch (ModelException e) {
            logger.warning("unable to parse data object in model: " + e.getMessage());
            return "";
        }
        List dataObjects = task.getItemValue("dataObjects");
        for (List dataObject : dataObjects) {
            String templateName = (String)dataObject.get(0);
            String content = (String)dataObject.get(1);
            if (!content.contains("<imixs-form>")) continue;
            logger.finest("......DataObject name=" + templateName);
            logger.finest("......DataObject content=" + content);
            return content;
        }
        return "";
    }

    private List<CustomFormItem> findItems(Element sectionElement, String _columns, boolean readOnly) throws ModelException {
        ArrayList<CustomFormItem> result = new ArrayList<CustomFormItem>();
        int span = 12;
        if ("2".equals(_columns)) {
            span = 6;
        }
        if ("3".equals(_columns)) {
            span = 4;
        }
        if ("4".equals(_columns)) {
            span = 3;
        }
        if ("6".equals(_columns)) {
            span = 2;
        }
        NodeList itemList = sectionElement.getElementsByTagName("item");
        for (int temp = 0; temp < itemList.getLength(); ++temp) {
            Node itemNode = itemList.item(temp);
            logger.finest("......parsing item...");
            if (itemNode.getNodeType() != 1) continue;
            Element itemElement = (Element)itemNode;
            if (itemElement.hasAttribute("span")) {
                try {
                    span = Integer.parseInt(itemElement.getAttribute("span"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean defaultReadOnly = false;
            defaultReadOnly = readOnly ? true : this.evaluateBoolean(itemElement.getAttribute("readonly"));
            CustomFormItem customItem = new CustomFormItem(itemElement.getAttribute("name"), itemElement.getAttribute("type"), itemElement.getAttribute("label"), this.evaluateBoolean(itemElement.getAttribute("required")), defaultReadOnly, this.evaluateBoolean(itemElement.getAttribute("disabled")), itemElement.getAttribute("options"), itemElement.getAttribute("path"), this.evaluateBoolean(itemElement.getAttribute("hide")), span);
            result.add(customItem);
        }
        return result;
    }

    private boolean evaluateBoolean(String expression) throws ModelException {
        if (expression == null || expression.isEmpty()) {
            return false;
        }
        if (expression.startsWith("#{") && expression.endsWith("}")) {
            if (this.supportedExpressions.contains(expression)) {
                FacesContext ctx = FacesContext.getCurrentInstance();
                Application app = ctx.getApplication();
                boolean result = (Boolean)app.evaluateExpressionGet(ctx, expression, Boolean.class);
                return result;
            }
            throw new ModelException("INVALID_MODEL_ENTRY", "The custom-form expression is not allowed: " + expression);
        }
        return Boolean.parseBoolean(expression);
    }

    private void loadCustomFormExpressions() {
        block9: {
            try {
                StringBuilder resultStringBuilder = new StringBuilder();
                try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getFileFromResourceAsStream("customform.expressions")));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        resultStringBuilder.append(line).append("\n");
                    }
                }
                this.supportedExpressions = resultStringBuilder.toString();
            }
            catch (Exception e) {
                logger.warning("unable to find customform.expressions in current classpath");
                if (!logger.isLoggable(Level.FINE)) break block9;
                e.printStackTrace();
            }
        }
    }

    private InputStream getFileFromResourceAsStream(String fileName) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new IllegalArgumentException("file not found! " + fileName);
        }
        return inputStream;
    }
}

