/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.gdpr;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.office.gdpr.GDPRAnonymiseService;
import org.imixs.workflow.util.XMLParser;

public class GDPRAnonymiseAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(GDPRAnonymiseAdapter.class.getName());
    public static String PROCESSING_ERROR = "PROCESSING_ERROR";
    public static final String CONFIG_ERROR = "CONFIG_ERROR";
    @Inject
    GDPRAnonymiseService gdprAnonymiseService;
    @Inject
    DocumentService documentService;

    public ItemCollection execute(ItemCollection workitem, ItemCollection event) throws AdapterException, PluginException {
        List gdprConfigList = null;
        String workflowResult = event.getItemValueString("txtActivityResult");
        gdprConfigList = XMLParser.parseTagList((String)workflowResult, (String)"gdpr");
        if (gdprConfigList == null || gdprConfigList.size() == 0) {
            throw new ProcessingErrorException(GDPRAnonymiseAdapter.class.getSimpleName(), CONFIG_ERROR, "missing gdpr configuraiton in BPMN event!");
        }
        for (ItemCollection gdprConfig : gdprConfigList) {
            List outgoinReferences = new ArrayList();
            String deleteItems = gdprConfig.getItemValueString("delete");
            String anonymiseItems = gdprConfig.getItemValueString("anonymise");
            String placeholder = gdprConfig.getItemValueString("placeholder");
            String anonymiseReferences = gdprConfig.getItemValueString("references");
            this.gdprAnonymiseService.deleteItems(workitem, deleteItems);
            this.gdprAnonymiseService.anonimiseItems(workitem, anonymiseItems, placeholder);
            if ("OUT".equals(anonymiseReferences) || "ALL".equals(anonymiseReferences)) {
                logger.info("...anonymise outgoing references...");
                outgoinReferences = workitem.getItemValue("$workitemref");
                for (String refid : outgoinReferences) {
                    ItemCollection refWorkitem = this.documentService.load(refid);
                    if (refWorkitem == null) continue;
                    this.gdprAnonymiseService.deleteItems(refWorkitem, deleteItems);
                    this.gdprAnonymiseService.anonimiseItems(refWorkitem, anonymiseItems, placeholder);
                    this.gdprAnonymiseService.save(refWorkitem);
                }
            }
            if (!"IN".equals(anonymiseReferences) && !"ALL".equals(anonymiseReferences)) continue;
            logger.info("...anonymise ingoing references...");
            String searchTerm = "($workitemref:\"" + workitem.getUniqueID() + "\" )";
            try {
                List refList = this.documentService.find(searchTerm, 99999, 0);
                for (ItemCollection refWorkitem : refList) {
                    if (outgoinReferences.contains(refWorkitem.getUniqueID())) continue;
                    this.gdprAnonymiseService.deleteItems(refWorkitem, deleteItems);
                    this.gdprAnonymiseService.anonimiseItems(refWorkitem, anonymiseItems, placeholder);
                    this.gdprAnonymiseService.save(refWorkitem);
                }
            }
            catch (QueryException e) {
                throw new PluginException(e.getErrorContext(), e.getErrorCode(), e.getMessage(), (Exception)((Object)e));
            }
        }
        return workitem;
    }
}

