/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.gdpr;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.Singleton;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.PluginException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Singleton
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
public class GDPRAnonymiseService {
    private static Logger logger = Logger.getLogger(GDPRAnonymiseService.class.getName());
    public static String PROCESSING_ERROR = "PROCESSING_ERROR";
    @Inject
    DocumentService documentService;

    public ItemCollection deleteItems(ItemCollection workitem, String itemDescription) throws PluginException {
        logger.finest("......delete items for '" + workitem.getUniqueID() + "'");
        List<String> itemList = this.resolveItemDescription(workitem, itemDescription);
        if (itemList != null && !itemList.isEmpty()) {
            for (String itemName : itemList) {
                logger.finest("......delete item: " + itemName);
                workitem.removeItem(itemName);
            }
        }
        return workitem;
    }

    public ItemCollection anonimiseItems(ItemCollection workitem, String itemDescription, String placeholder) throws PluginException {
        logger.finest("......anonymizing items for '" + workitem.getUniqueID() + "'. Placeholder='" + placeholder + "'");
        List<String> itemList = this.resolveItemDescription(workitem, itemDescription);
        if (itemList != null && !itemList.isEmpty()) {
            for (String itemName : itemList) {
                logger.finest("......anonymize item: " + itemName);
                workitem.replaceItemValue(itemName, (Object)placeholder);
            }
        }
        return workitem;
    }

    public List<String> resolveItemDescription(ItemCollection workitem, String itemDescription) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(itemDescription, ",");
        while (st.hasMoreTokens()) {
            String key = st.nextToken().trim();
            if (key.startsWith("(") && key.endsWith(")")) {
                Pattern itemPattern = Pattern.compile(key);
                Map map = workitem.getAllItems();
                for (String itemName : map.keySet()) {
                    if (!itemPattern.matcher(itemName).find()) continue;
                    result.add(itemName);
                }
                continue;
            }
            result.add(key);
        }
        while (result.contains("$uniqueid")) {
            result.remove("$uniqueid");
        }
        return result;
    }

    public void save(ItemCollection workitem) {
        this.documentService.save(workitem);
    }
}

