/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.report;

import jakarta.ejb.EJB;
import jakarta.enterprise.context.SessionScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.faces.data.DocumentController;
import org.imixs.workflow.xml.XMLDocumentAdapter;
import org.xml.sax.SAXException;

@Named
@SessionScoped
public class ReportController
implements Serializable {
    private ItemCollection reportUploads = new ItemCollection();
    @EJB
    protected ReportService reportService;
    @Inject
    DocumentController documentController;
    Map<String, String> params;
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ReportController.class.getName());

    public void reset() {
        this.params = null;
        this.reportUploads = new ItemCollection();
    }

    public ItemCollection getReportUploads() {
        return this.reportUploads;
    }

    public void setReportUploads(ItemCollection reportUploads) {
        this.reportUploads = reportUploads;
    }

    public List<ItemCollection> getReports() {
        return this.reportService.findAllReports();
    }

    public Map<String, String> getParams() {
        logger.fine("parsing params...");
        ItemCollection report = this.documentController.getDocument();
        if (this.params == null && report != null) {
            this.params = new LinkedHashMap<String, String>();
            String query = report.getItemValueString("txtquery");
            int i = 0;
            while ((i = query.indexOf(123, i)) > -1) {
                int j = query.indexOf(125, i);
                if (j <= -1) continue;
                String sKey = query.substring(i + 1, j);
                this.params.put(sKey, "");
                i = j;
            }
            i = 0;
            boolean found = false;
            while ((i = query.indexOf(63, i)) > -1) {
                String sTest = query.substring(i + 1);
                for (int j = 0; j < sTest.length(); ++j) {
                    char c = sTest.charAt(j);
                    if (c != '\'' && c != '\"' && c != ']' && c != ':' && c != ' ' && c != ')') continue;
                    String sKey = query.substring(i + 1, i + j + 1);
                    logger.warning("...detected old report param format. Replace ?xxx with {xxx}");
                    this.params.put(sKey, "");
                    ++i;
                    found = true;
                    break;
                }
                if (found) continue;
                logger.warning("...unable to parse report param format. Replace ?xxx with {xxx}");
                break;
            }
        }
        return this.params;
    }

    public void uploadReport() throws ModelException, ParseException, ParserConfigurationException, SAXException, IOException, JAXBException {
        List fileList = this.getReportUploads().getFileData();
        if (fileList == null) {
            return;
        }
        for (FileData file : fileList) {
            logger.info("Import report: " + file.getName());
            if (file.getName().endsWith(".imixs-report")) {
                ByteArrayInputStream input = new ByteArrayInputStream(file.getContent());
                ItemCollection report = XMLDocumentAdapter.readItemCollectionFromInputStream((InputStream)input);
                this.reportService.updateReport(report);
                continue;
            }
            logger.warning("Invalid Report Type. Report can't be imported!");
        }
        this.reportUploads = new ItemCollection();
    }
}

