/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.util;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.office.config.ConfigService;
import org.imixs.workflow.util.XMLParser;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Singleton
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
public class SequenceService {
    public static final String ITEM_SEQUENCENUMBER = "sequencenumber";
    public static final String ITEM_SEQUENCENUMBER_DEPRECATED = "numsequencenumber";
    private static Logger logger = Logger.getLogger(SequenceService.class.getName());
    @EJB
    ConfigService configService;
    @EJB
    DocumentService documentService;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void computeSequenceNumber(ItemCollection documentContext) throws AccessDeniedException {
        if (this.hasSequenceNumber(documentContext)) {
            return;
        }
        ItemCollection configItemCollection = this.configService.loadConfiguration("BASIC", true);
        if (configItemCollection != null) {
            String sWorkflowGroup = documentContext.getItemValueString("$workflowgroup");
            List vNumbers = configItemCollection.getItemValue("sequencenumbers");
            String groupIdentifier = null;
            String generalIdentifier = null;
            int identifierPosition = -1;
            for (String aIdentifier : vNumbers) {
                if (aIdentifier.startsWith(sWorkflowGroup + "=")) {
                    groupIdentifier = aIdentifier;
                }
                if (!aIdentifier.startsWith("[GENERAL]=")) continue;
                generalIdentifier = aIdentifier;
            }
            if (groupIdentifier == null && generalIdentifier != null) {
                groupIdentifier = generalIdentifier;
                sWorkflowGroup = "[GENERAL]";
            }
            if (groupIdentifier != null) {
                SequenceNumber seqn = new SequenceNumber(groupIdentifier.substring(groupIdentifier.indexOf(61) + 1));
                documentContext.replaceItemValue(ITEM_SEQUENCENUMBER, (Object)seqn.nextSequenceNumber);
                documentContext.replaceItemValue(ITEM_SEQUENCENUMBER_DEPRECATED, (Object)seqn.nextSequenceNumber);
                for (int i = 0; i < vNumbers.size(); ++i) {
                    if (!((String)vNumbers.get(i)).startsWith(sWorkflowGroup + "=")) continue;
                    identifierPosition = i;
                    break;
                }
                if (identifierPosition > -1) {
                    vNumbers.set(identifierPosition, sWorkflowGroup + "=" + seqn.nextDev);
                    configItemCollection.replaceItemValue("sequencenumbers", (Object)vNumbers);
                    this.configService.save(configItemCollection);
                }
            } else {
                documentContext.removeItem(ITEM_SEQUENCENUMBER);
            }
        } else {
            logger.warning("No BASIC configuration found!");
        }
    }

    public boolean hasSequenceNumber(ItemCollection documentContext) {
        if (documentContext.hasItem(ITEM_SEQUENCENUMBER) && !documentContext.getItemValueString(ITEM_SEQUENCENUMBER).isEmpty()) {
            if (!documentContext.hasItem(ITEM_SEQUENCENUMBER_DEPRECATED)) {
                documentContext.replaceItemValue(ITEM_SEQUENCENUMBER_DEPRECATED, (Object)documentContext.getItemValue(ITEM_SEQUENCENUMBER));
            }
            return true;
        }
        if (documentContext.hasItem(ITEM_SEQUENCENUMBER_DEPRECATED) && !documentContext.getItemValueString(ITEM_SEQUENCENUMBER_DEPRECATED).isEmpty()) {
            documentContext.replaceItemValue(ITEM_SEQUENCENUMBER, (Object)documentContext.getItemValue(ITEM_SEQUENCENUMBER_DEPRECATED));
            return true;
        }
        return false;
    }

    public class SequenceNumber {
        private String digit = "";
        private String nextDigit = "";
        private String prafix = "";
        private String nextSequenceNumber = "";
        private String nextDev = "";

        public SequenceNumber(String def) {
            for (int i = def.length() - 1; i >= 0 && Character.isDigit(def.charAt(i)); --i) {
                this.digit = def.charAt(i) + this.digit;
            }
            this.prafix = def.substring(0, def.length() - this.digit.length());
            long l = Long.parseLong(this.digit);
            this.nextDigit = "" + (l + 1L);
            while (this.nextDigit.length() < this.digit.length()) {
                this.nextDigit = "0" + this.nextDigit;
            }
            this.nextDev = this.prafix + this.nextDigit;
            this.nextSequenceNumber = def;
            List dateTags = XMLParser.findTags((String)this.nextSequenceNumber, (String)"date");
            for (String tag : dateTags) {
                String pattern = XMLParser.findTagValue((String)tag, (String)"date");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                String dateValue = simpleDateFormat.format(new Date());
                this.nextSequenceNumber = this.nextSequenceNumber.replace(tag, dateValue);
            }
        }

        public String getDigit() {
            return this.digit;
        }

        public String getNextDigit() {
            return this.nextDigit;
        }

        public String getPrafix() {
            return this.prafix;
        }

        public String getNextSequenceNumber() {
            return this.nextSequenceNumber;
        }

        public String getNextDev() {
            return this.nextDev;
        }
    }
}

