/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.views;

import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.ViewScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.office.views.BoardCategory;
import org.imixs.workflow.office.views.BoardController;

@Named
@ViewScoped
public class MonitorController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> workflowGroups = null;
    private List<String> activeWorkflowGroups = null;
    private Set<BoardCategory> boardCategories;
    @Inject
    protected BoardController boardController;
    private static Logger logger = Logger.getLogger(MonitorController.class.getName());
    @EJB
    ModelService modelService = null;
    @EJB
    DocumentService documentService;

    @PostConstruct
    public void init() {
        FacesContext fc = FacesContext.getCurrentInstance();
        Map paramMap = fc.getExternalContext().getRequestParameterMap();
        this.boardController.setProcessRef((String)paramMap.get("processref"));
        this.workflowGroups = this.modelService.getGroups();
        this.reset();
    }

    public String getProcessRef() {
        return this.boardController.getProcessRef();
    }

    public ItemCollection getProcess() {
        return this.boardController.getProcess();
    }

    public List<String> getWorkflowGroups() {
        return this.workflowGroups;
    }

    public List<String> getActiveWorkflowGroups() {
        return this.activeWorkflowGroups;
    }

    public Set<BoardCategory> getBoardCategories() {
        return this.boardCategories;
    }

    public void setBoardCategories(Set<BoardCategory> boardCategories) {
        this.boardCategories = boardCategories;
    }

    public long countTotalWorkitems(String group) {
        int result = 0;
        if (group != null) {
            for (BoardCategory boardCat : this.boardCategories) {
                if (!group.equals(boardCat.getWorkflowGroup())) continue;
                result += boardCat.getPageSize();
            }
        }
        return result;
    }

    public void reset() {
        this.buildBoardCategories();
        this.activeWorkflowGroups = new ArrayList<String>();
        for (BoardCategory cat : this.boardCategories) {
            if (this.activeWorkflowGroups.contains(cat.getWorkflowGroup())) continue;
            this.activeWorkflowGroups.add(cat.getWorkflowGroup());
        }
        Collections.sort(this.activeWorkflowGroups);
    }

    public void refresh() {
    }

    @Deprecated
    public String getOverallData() {
        Object result = "{";
        result = (String)result + "labels : [ ";
        result = (String)result + this.activeWorkflowGroups.stream().collect(Collectors.joining("','", "'", "'"));
        result = (String)result + "],";
        result = (String)result + " datasets : [ { ";
        result = (String)result + " label : 'All Groups', ";
        ArrayList<CallSite> overAllCount = new ArrayList<CallSite>();
        for (String group : this.activeWorkflowGroups) {
            int count = 0;
            for (BoardCategory cat : this.boardCategories) {
                if (!group.equals(cat.getWorkflowGroup())) continue;
                count += cat.pageSize;
            }
            overAllCount.add((CallSite)((Object)("" + count)));
        }
        result = (String)result + " data: [ " + overAllCount.stream().collect(Collectors.joining(",")) + "],";
        result = (String)result + MonitorController.generateBackgroundColorScheme();
        result = (String)result + " } ] }";
        return result;
    }

    public String getGroupData() {
        Object result = "[";
        for (String group : this.activeWorkflowGroups) {
            result = (String)result + "{id:'" + this.getBase64(group) + "', name:'" + group + "',";
            result = (String)result + "data:" + this.buildChartData(group) + "},";
        }
        result = ((String)result).substring(0, ((String)result).length() - 1);
        result = (String)result + "]";
        return result;
    }

    public String getBase64(String key) {
        byte[] data = Base64.getEncoder().encode(key.getBytes());
        String result = new String(data);
        result = result.replace("=", "_");
        return result;
    }

    private void buildBoardCategories() {
        long l = System.currentTimeMillis();
        this.boardCategories = new HashSet<BoardCategory>();
        try {
            String query = "(type:\"workitem\" AND $uniqueidref:\"" + this.getProcessRef() + "\")";
            for (String group : this.workflowGroups) {
                List versions = this.modelService.findVersionsByGroup(group);
                if (versions == null || versions.size() <= 0) continue;
                String version = (String)versions.get(0);
                Model model = this.modelService.getModel(version);
                List tasks = model.findTasksByGroup(group);
                for (ItemCollection task : tasks) {
                    int taskID = task.getItemValueInteger("numprocessid");
                    String taskName = task.getItemValueString("name");
                    String taskQuery = query + " AND ($taskid:" + taskID + " AND $workflowgroup:\"" + group + "\")";
                    int count = this.documentService.count(taskQuery);
                    if (count <= 0) continue;
                    BoardCategory tmpCat = new BoardCategory(group, taskName, taskID, count);
                    this.boardCategories.add(tmpCat);
                }
            }
            logger.info("...build " + this.boardCategories.size() + " BoardCategories in " + (System.currentTimeMillis() - l) + "ms");
        }
        catch (ModelException | QueryException e) {
            logger.severe("...failed to BoardCategories: " + e.getMessage());
        }
    }

    private String buildChartData(String group) {
        ArrayList<String> statusLabels = new ArrayList<String>();
        ArrayList<BoardCategory> sortedBoardCategoriesByGroup = new ArrayList<BoardCategory>();
        for (BoardCategory cat : this.boardCategories) {
            if (!group.equals(cat.getWorkflowGroup())) continue;
            sortedBoardCategoriesByGroup.add(cat);
        }
        Collections.sort(sortedBoardCategoriesByGroup, new Comparator<BoardCategory>(){

            @Override
            public int compare(BoardCategory p1, BoardCategory p2) {
                return p1.toString().compareTo(p2.toString());
            }
        });
        for (BoardCategory cat : sortedBoardCategoriesByGroup) {
            statusLabels.add(cat.workflowStatus);
        }
        Object result = "{";
        result = (String)result + "labels : [ ";
        result = (String)result + statusLabels.stream().collect(Collectors.joining("','", "'", "'"));
        result = (String)result + "],";
        result = (String)result + " datasets : [ { ";
        result = (String)result + " label : '" + group + "', ";
        ArrayList<CallSite> statusCount = new ArrayList<CallSite>();
        for (BoardCategory cat : sortedBoardCategoriesByGroup) {
            if (!group.equals(cat.getWorkflowGroup())) continue;
            statusCount.add((CallSite)((Object)("" + cat.pageSize)));
        }
        result = (String)result + " data: [ " + statusCount.stream().collect(Collectors.joining(",")) + "],";
        result = (String)result + MonitorController.generateBackgroundColorScheme();
        result = (String)result + " } ] }";
        return result;
    }

    public static String generateBackgroundColorScheme() {
        String result = " \"backgroundColor\" : [\n   \"#3B6B82\",\"#70B088\",\"#EBA05F\",\"#9B3425\",\"#CFE9F5\",\"#F1D437\",\"#E73B65\",\"#462645\",\"#2D6CA8\",\"#2B5C33\",\"#F28E1C\",\"#F3E500\" ]";
        return result;
    }
}

