/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.views;

import jakarta.faces.view.ViewScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObjectBuilder;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.marty.profile.UserController;
import org.imixs.marty.team.TeamController;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.faces.data.ViewController;
import org.imixs.workflow.faces.util.ResourceBundleHandler;

@Named
@ViewScoped
public class OrganigramController
extends ViewController {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(OrganigramController.class.getName());
    @Inject
    TeamController teamController;
    @Inject
    ResourceBundleHandler resourceBundleHandler;
    @Inject
    UserController userController;
    @Inject
    DocumentService documentService;
    private String selectedNodeID = null;
    private ItemCollection selectedNode = null;

    public String getSelectedNodeID() {
        return this.selectedNodeID;
    }

    public void setSelectedNodeID(String selectedNodeID) {
        this.selectedNodeID = selectedNodeID;
    }

    public ItemCollection getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(ItemCollection selectedNode) {
        this.selectedNode = selectedNode;
    }

    public String getProcessDatasource() {
        List processList = this.teamController.getProcessList();
        JsonObjectBuilder jsonBuilder = Json.createObjectBuilder();
        jsonBuilder.add("id", "root").add("name", this.resourceBundleHandler.findMessage("organigram.processes")).add("title", this.resourceBundleHandler.findMessage("organigram.processes.description"));
        if (processList != null && processList.size() > 0) {
            JsonArrayBuilder childList = Json.createArrayBuilder();
            for (ItemCollection process : processList) {
                String userName;
                JsonObjectBuilder processObject = Json.createObjectBuilder();
                processObject.add("name", process.getItemValueString("name")).add("title", process.getItemValueString("txtdescription")).add("id", process.getUniqueID()).add("className", "process");
                List members = process.getItemValue("process.team");
                JsonArrayBuilder memberArray = Json.createArrayBuilder();
                for (String member : members) {
                    userName = this.userController.getUserName(member);
                    if (userName == null) continue;
                    memberArray.add(userName);
                }
                processObject.add("team", memberArray);
                members = process.getItemValue("process.manager");
                memberArray = Json.createArrayBuilder();
                for (String member : members) {
                    userName = this.userController.getUserName(member);
                    if (userName == null) continue;
                    memberArray.add(userName);
                }
                processObject.add("manager", memberArray);
                members = process.getItemValue("process.assist");
                memberArray = Json.createArrayBuilder();
                for (String member : members) {
                    userName = this.userController.getUserName(member);
                    if (userName == null) continue;
                    memberArray.add(userName);
                }
                processObject.add("assist", memberArray);
                childList.add(processObject);
            }
            jsonBuilder.add("children", childList);
        }
        String result = jsonBuilder.build().toString();
        return result;
    }

    public String getSpaceDatasource() {
        JsonObjectBuilder jsonBuilder = Json.createObjectBuilder();
        jsonBuilder.add("id", "root").add("name", this.resourceBundleHandler.findMessage("organigram.spaces")).add("title", this.resourceBundleHandler.findMessage("organigram.spaces.description"));
        JsonArrayBuilder rootSpaces = this.buildSpacesObjectArray(null);
        if (rootSpaces != null) {
            jsonBuilder.add("children", rootSpaces);
        }
        String result = jsonBuilder.build().toString();
        return result;
    }

    private JsonArrayBuilder buildSpacesObjectArray(String parentSpaceID) {
        List spacesList = null;
        if (parentSpaceID == null || parentSpaceID.isEmpty()) {
            spacesList = this.teamController.getRootSpaces();
            logger.finest("...add root spaces...");
        } else {
            spacesList = this.teamController.getSpacesByRef(parentSpaceID);
            logger.finest("...add sub spaces for " + parentSpaceID);
        }
        if (spacesList == null || spacesList.size() == 0) {
            return null;
        }
        JsonArrayBuilder childListArray = Json.createArrayBuilder();
        for (ItemCollection space : spacesList) {
            String userName;
            JsonObjectBuilder spaceObject = Json.createObjectBuilder().add("name", space.getItemValueString("space.name")).add("title", space.getItemValueString("txtdescription")).add("id", space.getUniqueID()).add("manager.label", space.getItemValueString("space.manager.label")).add("team.label", space.getItemValueString("space.team.label")).add("assist.label", space.getItemValueString("space.assist.label")).add("className", "space");
            List members = space.getItemValue("space.team");
            JsonArrayBuilder memberArray = Json.createArrayBuilder();
            for (String member : members) {
                userName = this.userController.getUserName(member);
                if (userName == null) continue;
                memberArray.add(userName);
            }
            spaceObject.add("team", memberArray);
            members = space.getItemValue("space.manager");
            memberArray = Json.createArrayBuilder();
            for (String member : members) {
                userName = this.userController.getUserName(member);
                if (userName == null) continue;
                memberArray.add(userName);
            }
            spaceObject.add("manager", memberArray);
            members = space.getItemValue("space.assist");
            memberArray = Json.createArrayBuilder();
            for (String member : members) {
                userName = this.userController.getUserName(member);
                if (userName == null) continue;
                memberArray.add(userName);
            }
            spaceObject.add("assist", memberArray);
            JsonArrayBuilder subSpaces = this.buildSpacesObjectArray(space.getUniqueID());
            if (subSpaces != null) {
                logger.finest("...found sub spaces!");
                spaceObject.add("children", subSpaces);
            }
            childListArray.add(spaceObject);
        }
        return childListArray;
    }

    public void loadNode() {
        logger.finest("...load selected node : " + this.getSelectedNodeID());
        this.selectedNode = this.documentService.load(this.selectedNodeID);
    }
}

