/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.office.forms.AnalyticEvent;

@Named
@ConversationScoped
public class AnalyticController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(AnalyticController.class.getName());
    @Inject
    protected Event<AnalyticEvent> analyticEvents;
    @Inject
    protected WorkflowController workflowController;

    public String getAsString(String key) {
        ItemCollection analyticData = this.computeValue(key);
        return analyticData.getItemValueString("value");
    }

    public String getAsJson(String key) {
        ItemCollection analyticData = this.computeValue(key);
        String jsonval = analyticData.getItemValueString("value");
        if (jsonval == null || jsonval.isEmpty()) {
            return "null";
        }
        return jsonval;
    }

    public double getAsDouble(String key) {
        ItemCollection analyticData = this.computeValue(key);
        return analyticData.getItemValueDouble("value");
    }

    public String getLabel(String key) {
        ItemCollection analyticData = this.computeValue(key);
        return analyticData.getItemValueString("label");
    }

    public String getLink(String key) {
        ItemCollection analyticData = this.computeValue(key);
        return analyticData.getItemValueString("link");
    }

    public String getDescription(String key) {
        ItemCollection analyticData = this.computeValue(key);
        return analyticData.getItemValueString("description");
    }

    protected ItemCollection computeValue(String key) {
        if (this.workflowController.getWorkitem() != null) {
            logger.fine("fire analytic event for key '" + key + "'");
            AnalyticEvent event = new AnalyticEvent(key, this.workflowController.getWorkitem());
            if (this.analyticEvents != null) {
                this.analyticEvents.fire((Object)event);
                if (event.getValue() != null) {
                    ItemCollection details = new ItemCollection();
                    details.setItemValue("value", event.getValue());
                    details.setItemValue("label", (Object)event.getLabel());
                    details.setItemValue("description", (Object)event.getDescription());
                    details.setItemValue("link", (Object)event.getLink());
                    this.implodeDetails(key, details);
                }
            }
        }
        return this.explodeDetails(key);
    }

    private void implodeDetails(String key, ItemCollection details) {
        ArrayList<Map> detailsList = new ArrayList<Map>();
        detailsList.add(details.getAllItems());
        this.workflowController.getWorkitem().replaceItemValue(key, detailsList);
    }

    private ItemCollection explodeDetails(String key) {
        List mapOrderItems = this.workflowController.getWorkitem().getItemValue(key);
        if (mapOrderItems != null && mapOrderItems.size() > 0) {
            ItemCollection itemCol = new ItemCollection((Map)mapOrderItems.get(0));
            return itemCol;
        }
        ItemCollection dummy = new ItemCollection();
        dummy.setItemValue("value", (Object)"");
        dummy.setItemValue("label", (Object)"");
        dummy.setItemValue("description", (Object)"No data available");
        return dummy;
    }
}

