/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.FacesValidator;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import org.iban4j.BicFormatException;
import org.iban4j.BicUtil;
import org.iban4j.InvalidCheckDigitException;
import org.iban4j.UnsupportedCountryException;

@FacesValidator(value="imixsBICValidator")
public class BICValidator
implements Validator<String> {
    public void validate(FacesContext context, UIComponent component, String value) throws ValidatorException {
        if (value != null && !value.isEmpty()) {
            try {
                if (value.contains(" ")) {
                    value = value.replaceAll("\\s+", "");
                }
                BicUtil.validate((String)value);
            }
            catch (BicFormatException | InvalidCheckDigitException | UnsupportedCountryException e) {
                throw new ValidatorException(new FacesMessage(e.getMessage()));
            }
        }
    }
}

