/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ActionEvent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.faces.data.WorkflowEvent;
import org.imixs.workflow.faces.util.LoginController;

@Named(value="dmsController")
@ConversationScoped
public class DMSController
implements Serializable {
    public static final String REGEX_URL_PATTERN = "^(http|https|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    @Inject
    protected LoginController loginController = null;
    @Inject
    protected WorkflowController workflowController;
    @Inject
    protected DocumentService documentService;
    private static final long serialVersionUID = 1L;
    private List<ItemCollection> dmsList = null;
    private String link = null;
    private Map<String, List<ItemCollection>> dmsListCache = null;
    private static Logger logger = Logger.getLogger(DMSController.class.getName());

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) throws AccessDeniedException {
        if (workflowEvent == null) {
            return;
        }
        if (workflowEvent.getWorkitem() != null && !workflowEvent.getWorkitem().getItemValueString("type").startsWith("workitem")) {
            return;
        }
        int eventType = workflowEvent.getEventType();
        if (20 == eventType || 21 == eventType) {
            this.reset();
        }
        if (22 == eventType && this.dmsList != null) {
            this.putDmsList(workflowEvent.getWorkitem(), this.dmsList);
        }
    }

    private void putDmsList(ItemCollection workitem, List<ItemCollection> dmsList) {
        for (ItemCollection dmsEntry : dmsList) {
            String filename = dmsEntry.getItemValueString("txtname");
            if (filename.isEmpty()) {
                logger.warning("Invalid DMS entry: txtname is empty!");
                return;
            }
            FileData fileData = workitem.getFileData(filename);
            if (fileData != null) {
                fileData.setAttributes(dmsEntry.getAllItems());
                workitem.addFileData(fileData);
                continue;
            }
            if (filename.matches(REGEX_URL_PATTERN)) {
                byte[] empty = new byte[]{};
                FileData linkData = new FileData(filename, empty, null, dmsEntry.getAllItems());
                workitem.addFileData(linkData);
                continue;
            }
            logger.warning("Invalid DMS entry: '" + filename + "' is unknown!");
        }
    }

    public List<ItemCollection> getDmsList() {
        if (this.dmsList == null) {
            this.dmsList = this.getDmsListByWorkitem(this.workflowController.getWorkitem());
        }
        return this.dmsList;
    }

    public List<ItemCollection> getDmsListByWorkitem(ItemCollection workitem) {
        if (this.dmsListCache == null) {
            this.dmsListCache = new HashMap<String, List<ItemCollection>>();
        }
        if (workitem == null || workitem.getUniqueID().isEmpty()) {
            return new ArrayList<ItemCollection>();
        }
        List<ItemCollection> _dmsList = this.dmsListCache.get(workitem.getUniqueID());
        if (_dmsList != null) {
            return _dmsList;
        }
        _dmsList = new ArrayList<ItemCollection>();
        ItemCollection _workitem = workitem;
        if (!_workitem.hasItem("$file")) {
            _workitem = this.documentService.load(workitem.getUniqueID());
            logger.finest("......loaded full data for " + workitem.getUniqueID());
        }
        List files = _workitem.getFileData();
        for (FileData fileData : files) {
            if (fileData.getAttributes().get("txtname") == null) {
                ArrayList<String> values = new ArrayList<String>();
                values.add(fileData.getName());
                fileData.setAttribute("txtname", values);
                fileData.setAttribute("$created", workitem.getItemValue("$created"));
            }
            ItemCollection _dmsItemCol = new ItemCollection(fileData.getAttributes());
            _dmsItemCol.setItemValue("name", (Object)_dmsItemCol.getItemValueString("txtname"));
            try {
                String encodedName = URLEncoder.encode(_dmsItemCol.getItemValueString("name"), "UTF-8");
                _dmsItemCol.setItemValue("name.encoded", (Object)encodedName);
            }
            catch (UnsupportedEncodingException e) {
                logger.warning("unable to URL encode the filename '" + fileData.getAttribute("name") + "'!");
            }
            _dmsList.add(_dmsItemCol);
        }
        Collections.sort(_dmsList, new ItemCollectionComparator("$created", true));
        this.dmsListCache.put(workitem.getUniqueID(), _dmsList);
        return _dmsList;
    }

    public void removeFile(String aFile) {
        this.workflowController.getWorkitem().removeFile(aFile);
        this.reset();
    }

    public void reset() {
        this.dmsList = null;
        this.dmsListCache = null;
    }

    public void addLink(ActionEvent event) {
        Object sLink = this.getLink();
        if (sLink != null && !"".equals(sLink)) {
            if (!((String)sLink).contains("://")) {
                sLink = "http://" + (String)sLink;
            }
            FacesContext context = FacesContext.getCurrentInstance();
            ExternalContext externalContext = context.getExternalContext();
            String remoteUser = externalContext.getRemoteUser();
            ItemCollection dmsEntry = new ItemCollection();
            dmsEntry.replaceItemValue("url", sLink);
            dmsEntry.replaceItemValue("$created", (Object)new Date());
            dmsEntry.replaceItemValue("$modified", (Object)new Date());
            dmsEntry.replaceItemValue("namCreator", (Object)remoteUser);
            dmsEntry.replaceItemValue("$Creator", (Object)remoteUser);
            dmsEntry.replaceItemValue("txtName", sLink);
            this.dmsList = this.addDMSEntry(this.workflowController.getWorkitem(), dmsEntry);
            this.setLink("");
        }
    }

    private List<ItemCollection> addDMSEntry(ItemCollection aworkitem, ItemCollection dmsEntity) {
        List<ItemCollection> dmsList = this.getDmsListByWorkitem(aworkitem);
        String sNewName = dmsEntity.getItemValueString("txtName");
        String sNewUrl = dmsEntity.getItemValueString("url");
        Iterator<ItemCollection> iterator = dmsList.iterator();
        while (iterator.hasNext()) {
            ItemCollection admsEntry = iterator.next();
            String sName = admsEntry.getItemValueString("txtName");
            String sURL = admsEntry.getItemValueString("url");
            if (!sURL.endsWith(sNewUrl) || !sName.equals(sNewName)) continue;
            iterator.remove();
            logger.fine("remove dms entry '" + sName + "'");
        }
        dmsList.add(dmsEntity);
        this.putDmsList(aworkitem, dmsList);
        return dmsList;
    }

    public String userFriendlyBytes(int bytes) {
        int unit;
        boolean si = true;
        int n = unit = si ? 1000 : 1024;
        if (bytes < unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public String documentType(String name) {
        if ((name = name.toLowerCase()).endsWith(".doc") || name.endsWith(".docx") || name.endsWith(".xls") || name.endsWith(".xlsx")) {
            return "win";
        }
        if (name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".gif") || name.endsWith(".tif") || name.endsWith(".tiff")) {
            return "pic";
        }
        if (name.endsWith(".pdf")) {
            return "pdf";
        }
        if (name.endsWith(".eml")) {
            return "eml";
        }
        return "doc";
    }
}

