/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.FacesConverter;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

@FacesConverter(value="imixsDateConverter")
public class DateConverter
implements Converter,
Serializable {
    private static final String DEFAULT_DATE_FORMAT_PATTERN = "yyyy-mm-dd";
    private static final String DEFAULT_TIME_ZONE = "UTC";

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (value == null || value.trim().isEmpty()) {
            return "";
        }
        try {
            String timezone;
            value = value.trim();
            String pattern = (String)component.getAttributes().get("org.imixs.date.pattern");
            if (pattern == null || pattern.isEmpty()) {
                pattern = DEFAULT_DATE_FORMAT_PATTERN;
            }
            if ((timezone = (String)component.getAttributes().get("org.imixs.date.timeZone")) == null || timezone.isEmpty()) {
                timezone = DEFAULT_TIME_ZONE;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            dateFormat.setTimeZone(TimeZone.getTimeZone(timezone));
            return dateFormat.parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException("Error converting date", e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value == null || "".equals(value)) {
            return "";
        }
        if (value instanceof Date) {
            String timezone;
            String pattern = (String)component.getAttributes().get("org.imixs.date.pattern");
            if (pattern == null || pattern.isEmpty()) {
                pattern = DEFAULT_DATE_FORMAT_PATTERN;
            }
            if ((timezone = (String)component.getAttributes().get("org.imixs.date.timeZone")) == null || timezone.isEmpty()) {
                timezone = DEFAULT_TIME_ZONE;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            dateFormat.setTimeZone(TimeZone.getTimeZone(timezone));
            return dateFormat.format((Date)value);
        }
        throw new IllegalArgumentException("Invalid value type: " + value.getClass().getName());
    }
}

