/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.imixs.marty.profile.UserController;
import org.imixs.marty.team.TeamController;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.faces.data.WorkflowEvent;
import org.imixs.workflow.faces.util.ResourceBundleHandler;
import org.imixs.workflow.office.forms.FormDefinition;
import org.imixs.workflow.office.forms.FormSection;

@Named
@ConversationScoped
public class FormController
implements Serializable {
    public static final String DEFAULT_EDITOR_ID = "form_basic";
    @Inject
    protected TeamController processController;
    @Inject
    protected UserController userController;
    @Inject
    protected ResourceBundleHandler resourceBundleHandler;
    private static final long serialVersionUID = 1L;
    private FormDefinition formDefinition = null;
    private static Logger logger = Logger.getLogger(FormController.class.getName());

    public FormDefinition getFormDefinition() {
        if (this.formDefinition == null) {
            logger.warning("formDefinition is null - verify model definition and the workitem 'type' attribute'.");
            this.formDefinition = new FormDefinition();
            this.computeFormDefinition(new ItemCollection());
        }
        return this.formDefinition;
    }

    public void setFormDefinition(FormDefinition formDefinition) {
        this.formDefinition = formDefinition;
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) throws AccessDeniedException {
        if (workflowEvent == null) {
            return;
        }
        if (!workflowEvent.getWorkitem().hasItem("txtWorkflowEditorid")) {
            return;
        }
        int eventType = workflowEvent.getEventType();
        if (21 == eventType || 20 == eventType || 23 == eventType) {
            this.computeFormDefinition(workflowEvent.getWorkitem());
        }
    }

    public FormDefinition computeFormDefinition(ItemCollection aworkitem) {
        this.formDefinition = new FormDefinition();
        String editorID = DEFAULT_EDITOR_ID;
        if (aworkitem == null) {
            return this.formDefinition;
        }
        String currentEditor = aworkitem.getItemValueString("txtWorkflowEditorid");
        if (!currentEditor.isEmpty()) {
            editorID = currentEditor;
        }
        if (editorID.indexOf(35) == -1) {
            this.formDefinition.setPath(editorID);
            return this.formDefinition;
        }
        String sMainForm = editorID.substring(0, editorID.indexOf(35));
        this.formDefinition.setPath(sMainForm);
        this.formDefinition.setName(this.findResourceNameByPath(sMainForm));
        StringTokenizer subSections = new StringTokenizer(editorID.substring(editorID.indexOf(35) + 1), "|");
        while (subSections.hasMoreTokens()) {
            try {
                String path = subSections.nextToken();
                if (path.indexOf(91) > -1 || path.indexOf(93) > -1) {
                    boolean bPermissionGranted = false;
                    String sPermissions = path.substring(path.indexOf(91) + 1, path.indexOf(93));
                    path = path.substring(0, path.indexOf(91));
                    StringTokenizer stPermission = new StringTokenizer(sPermissions, ",");
                    while (stPermission.hasMoreTokens()) {
                        String aPermission = stPermission.nextToken();
                        ExternalContext ectx = FacesContext.getCurrentInstance().getExternalContext();
                        if (ectx.isUserInRole(aPermission)) {
                            bPermissionGranted = true;
                            break;
                        }
                        String sProjectUniqueID = aworkitem.getItemValueString("txtProcessRef");
                        if ("manager".equalsIgnoreCase(aPermission) && this.processController.isManagerOf(sProjectUniqueID)) {
                            bPermissionGranted = true;
                            break;
                        }
                        if (!"team".equalsIgnoreCase(aPermission) || !this.processController.isTeamMemberOf(sProjectUniqueID)) continue;
                        bPermissionGranted = true;
                        break;
                    }
                    if (!bPermissionGranted) continue;
                }
                String sName = this.findResourceNameByPath(path);
                FormSection aSection = new FormSection(path, sName);
                this.formDefinition.getSections().add(aSection);
            }
            catch (Exception est) {
                logger.severe("[getEditorSections] can not parse EditorSections : '" + editorID + "'");
                logger.severe(est.getMessage());
            }
        }
        return this.formDefinition;
    }

    private String findResourceNameByPath(String path) {
        String sResouceURL = path.replace('/', '_');
        return this.resourceBundleHandler.get(sResouceURL);
    }
}

