/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.model;

import jakarta.ejb.EJB;
import jakarta.enterprise.context.RequestScoped;
import jakarta.faces.event.ActionEvent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.bpmn.BPMNUtil;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.office.model.ModelUploadHandler;
import org.openbpmn.bpmn.BPMNModel;
import org.openbpmn.bpmn.exceptions.BPMNModelException;
import org.openbpmn.bpmn.util.BPMNModelFactory;

@Named
@RequestScoped
public class ModelController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    protected ModelUploadHandler modelUploadHandler;
    @EJB
    protected ModelService modelService;
    @EJB
    protected WorkflowService workflowService;
    private static Logger logger = Logger.getLogger(ModelController.class.getName());

    public List<String> getGroups(String version) {
        try {
            BPMNModel model = this.modelService.getModelManager().getModel(version);
            Set groups = this.modelService.getModelManager().findAllGroupsByModel(model);
            return new ArrayList<String>(groups);
        }
        catch (ModelException e) {
            logger.warning("Unable to load groups:" + e.getMessage());
            return new ArrayList<String>();
        }
    }

    public List<String> getWorkflowGroups() throws ModelException {
        ArrayList<String> result = new ArrayList<String>();
        for (BPMNModel model : this.modelService.getModelManager().getAllModels()) {
            String version = BPMNUtil.getVersion((BPMNModel)model);
            if (version.startsWith("system-")) continue;
            Set groups = this.modelService.getModelManager().findAllGroupsByModel(model);
            for (String groupName : groups) {
                if (result.contains(groupName) || groupName.contains("~")) continue;
                result.add(groupName);
            }
        }
        Collections.sort(result);
        return result;
    }

    public String getVersionByGroup(String group) throws ModelException {
        return this.modelService.getModelManager().findVersionByGroup(group);
    }

    public List<ItemCollection> findAllTasksByGroup(String group) {
        List<Object> result = new ArrayList<ItemCollection>();
        if (group == null || group.isEmpty()) {
            return result;
        }
        try {
            String version = this.modelService.getModelManager().findVersionByGroup(group);
            BPMNModel model = this.modelService.getModelManager().getModel(version);
            result = this.modelService.getModelManager().findTasks(model, group);
        }
        catch (ModelException e) {
            logger.warning("Failed to call findAllTasksByGroup for '" + group + "'");
        }
        return result;
    }

    public List<ItemCollection> findAllStartTasksByGroup(String version, String group) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        try {
            BPMNModel model = this.modelService.getModelManager().getModel(version);
            return this.modelService.getModelManager().findStartTasks(model, group);
        }
        catch (ModelException e) {
            logger.severe("Failed to find start tasks for workflow group '" + group + "' : " + e.getMessage());
            return result;
        }
    }

    public Set<String> getVersions() {
        return this.modelService.getModelEntityStore().keySet();
    }

    public ItemCollection getModelEntity(String version) {
        return this.modelService.loadModel(version);
    }

    public void doUploadModel(ActionEvent event) throws ModelException {
        List fileList = this.modelUploadHandler.getModelUploads().getFileData();
        if (fileList == null) {
            return;
        }
        for (FileData file : fileList) {
            if (file.getName().endsWith(".bpmn")) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getContent());
                try {
                    BPMNModel model = BPMNModelFactory.read((InputStream)inputStream);
                    this.modelService.saveModel(model);
                    continue;
                }
                catch (BPMNModelException e) {
                    throw new ModelException("INVALID_MODEL", "Unable to read model file: " + file.getName(), (Exception)((Object)e));
                }
            }
            logger.log(Level.WARNING, "Invalid Model Type. Model {0} can't be imported!", file.getName());
        }
        this.modelUploadHandler.reset();
    }

    public void deleteModel(String modelversion) throws AccessDeniedException, ModelException {
        this.modelService.deleteModel(modelversion);
    }

    public ItemCollection getProcessEntity(int processid, String modelversion) {
        try {
            BPMNModel model = this.modelService.getModelManager().getModel(modelversion);
            return this.modelService.getModelManager().findTaskByID(model, processid);
        }
        catch (ModelException e) {
            logger.warning("Unable to load task " + processid + " in model version '" + modelversion + "' - " + e.getMessage());
            return null;
        }
    }

    public String getProcessDescription(int processid, String modelversion, ItemCollection documentContext) {
        ItemCollection pe = null;
        try {
            BPMNModel model = this.modelService.getModelManager().getModel(modelversion);
            pe = this.modelService.getModelManager().findTaskByID(model, processid);
        }
        catch (ModelException e1) {
            logger.warning("Unable to load task " + processid + " in model version '" + modelversion + "' - " + e1.getMessage());
        }
        if (pe == null) {
            return "";
        }
        String desc = pe.getItemValueString("documentation");
        try {
            desc = this.workflowService.adaptText(desc, documentContext);
        }
        catch (PluginException e) {
            logger.warning("Unable to update processDescription: " + e.getMessage());
        }
        return desc;
    }

    public String getProcessDescriptionByInitialTask(ItemCollection initialTask, String modelVersion, String workflowGroup) {
        String result = "";
        if (initialTask != null) {
            ItemCollection dummy = new ItemCollection();
            dummy.setItemValue("$workflowstatus", (Object)initialTask.getItemValueString("name"));
            dummy.setItemValue("$workflowgroup", (Object)workflowGroup);
            result = this.getProcessDescription(initialTask.getItemValueInteger("taskid"), modelVersion, dummy);
        }
        return result;
    }
}

