/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.views;

import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import jakarta.faces.view.ViewScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.imixs.marty.team.TeamService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.faces.util.LoginController;

@Named
@ViewScoped
public class RolesAndRightsViewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    LoginController loginController;
    @Inject
    private DocumentService documentService;
    @EJB
    protected TeamService teamService;
    private List<ItemCollection> profiles;
    private List<ItemCollection> spaces;
    private List<ItemCollection> processList;

    @PostConstruct
    void init() throws QueryException {
        String _query = "(type:\"profile\") AND ($taskid:[210 TO 299]) ";
        this.profiles = this.documentService.find(_query, 9999, 0);
        Collections.sort(this.profiles, new ItemCollectionComparator("txtusername", true));
        _query = "type:\"space\"";
        this.spaces = this.documentService.find(_query, 9999, 0);
        Collections.sort(this.spaces, new ItemCollectionComparator("name", true));
        _query = "type:\"process\"";
        this.processList = this.documentService.find(_query, 9999, 0);
        Collections.sort(this.processList, new ItemCollectionComparator("name", true));
    }

    public List<ItemCollection> getProfiles() {
        return this.profiles;
    }

    public List<ItemCollection> getSpaces() {
        return this.spaces;
    }

    public List<ItemCollection> getProcessList() {
        return this.processList;
    }
}

