/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.plugins;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class CommentPlugin
extends AbstractPlugin {
    ItemCollection documentContext;
    private static Logger logger = Logger.getLogger(CommentPlugin.class.getName());

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection documentActivity) throws PluginException {
        this.documentContext = adocumentContext;
        ItemCollection evalItemCollection = this.getWorkflowService().evalWorkflowResult(documentActivity, "item", adocumentContext);
        if (evalItemCollection != null && "true".equals(evalItemCollection.getItemValueString("comment.ignore"))) {
            logger.fine("ignore=true - skipping txtCommentLog");
            this.documentContext.replaceItemValue("txtLastComment", (Object)this.documentContext.getItemValueString("txtComment"));
            return this.documentContext;
        }
        List vCommentList = this.documentContext.getItemValue("txtCommentLog");
        HashMap<String, Object> log = new HashMap<String, Object>();
        String remoteUser = this.getWorkflowService().getUserName();
        log.put("datcomment", this.documentContext.getItemValueDate("$lasteventdate"));
        log.put("nameditor", remoteUser);
        String sComment = null;
        if (evalItemCollection != null && evalItemCollection.hasItem("comment")) {
            sComment = evalItemCollection.getItemValueString("comment");
        } else {
            sComment = this.documentContext.getItemValueString("txtComment");
            this.documentContext.replaceItemValue("txtComment", (Object)"");
        }
        if (sComment != null && !sComment.isEmpty()) {
            log.put("txtcomment", sComment);
            vCommentList.add(0, log);
            this.documentContext.replaceItemValue("txtcommentLog", (Object)vCommentList);
            this.documentContext.replaceItemValue("txtLastComment", (Object)sComment);
        }
        this.documentContext.removeItem("comment");
        this.documentContext.removeItem("comment.ignore");
        return this.documentContext;
    }
}

