/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.config;

import jakarta.annotation.PostConstruct;
import jakarta.ejb.Singleton;
import jakarta.ejb.Startup;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.jpa.Document;
import org.imixs.workflow.office.config.PropertiesConfigSource;

@Startup
@Singleton
public class PropertiesLoader {
    @PersistenceContext(unitName="org.imixs.workflow.jpa")
    private EntityManager manager;
    private static Logger logger = Logger.getLogger(PropertiesLoader.class.getName());

    @PostConstruct
    void init() {
        this.reset();
    }

    public void reset() {
        PropertiesConfigSource.properties = this.loadProperties();
    }

    public Map<String, String> loadProperties() {
        ItemCollection basicConfig = this.getBasicConfigurationDocument();
        if (basicConfig != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            List v = basicConfig.getItemValue("properties");
            if (v.size() > 0) {
                logger.fine("...Update imixs.properties");
                for (Object o : v) {
                    String sProperty = (String)o;
                    int ipos = sProperty.indexOf(61);
                    if (ipos <= 0) continue;
                    String sKey = sProperty.substring(0, sProperty.indexOf(61));
                    String sValue = sProperty.substring(sProperty.indexOf(61) + 1);
                    logger.fine("Overwrite property/value: " + sKey + "=" + sValue);
                    properties.put(sKey, sValue);
                }
            }
            return properties;
        }
        return null;
    }

    private ItemCollection getBasicConfigurationDocument() {
        if (this.manager == null) {
            return null;
        }
        Object query = "SELECT document FROM Document AS document ";
        query = (String)query + " WHERE document.type = 'configuration'";
        Query q = this.manager.createQuery((String)(query = (String)query + " ORDER BY document.created DESC"));
        List documentList = q.getResultList();
        if (documentList != null) {
            for (Document doc : documentList) {
                ItemCollection configDocument = new ItemCollection(doc.getData());
                if (!configDocument.getItemValueString("txtname").equals("BASIC")) continue;
                return configDocument;
            }
        }
        logger.fine("BASIC configuration not found.");
        return null;
    }
}

