/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.imixs.ai.workflow.OpenAIAPIService;
import org.imixs.marty.profile.UserController;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.faces.data.WorkflowEvent;
import org.imixs.workflow.faces.util.LoginController;
import org.imixs.workflow.office.forms.ChildItemController;
import org.imixs.workflow.office.forms.ChronicleController;
import org.imixs.workflow.office.forms.ChronicleEntity;

@Named(value="aiController")
@ConversationScoped
public class AIController
implements Serializable {
    public static final String ERROR_PROMPT_TEMPLATE = "ERROR_PROMPT_TEMPLATE";
    public static final String ERROR_PROMPT_INFERENCE = "ERROR_PROMPT_INFERENCE";
    public static final String AI_CHAT_HISTORY = "ai.chat.history";
    public static final String AI_STREAM_EOS = "<!-- imixs.ai.stream.completed -->";
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(AIController.class.getName());
    List<ItemCollection> chatHistory;
    String currentStreamResult = "";
    String question = null;
    String answer = null;
    @Inject
    protected WorkflowController workflowController;
    @Inject
    protected ChronicleController chronicleController;
    @Inject
    protected UserController userController;
    @Inject
    protected LoginController loginController;
    @Inject
    OpenAIAPIService openAIAPIService;
    private CompletableFuture<Void> streamingFuture;

    public List<ItemCollection> getChatHistory() {
        if (this.chatHistory == null) {
            this.chatHistory = new ArrayList<ItemCollection>();
        }
        ArrayList<ItemCollection> reversedList = new ArrayList<ItemCollection>(this.chatHistory);
        Collections.reverse(reversedList);
        return reversedList;
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) {
        if (workflowEvent == null) {
            return;
        }
        if (20 == workflowEvent.getEventType() || 21 == workflowEvent.getEventType()) {
            this.chatHistory = ChildItemController.explodeChildList(this.workflowController.getWorkitem(), AI_CHAT_HISTORY);
        }
    }

    public void sendAsync() throws PluginException {
        ItemCollection workitem = this.workflowController.getWorkitem();
        this.question = workitem.getItemValueString("ai.chat.prompt").trim();
        if (this.question.isEmpty()) {
            return;
        }
        logger.fine("question: " + this.question);
        String prompt = this.buildContextPrompt(this.question);
        JsonObject jsonPrompt = this.openAIAPIService.buildJsonPromptObject(prompt, true, null);
        this.streamingFuture = CompletableFuture.runAsync(() -> {
            try {
                this.streamPromptCompletion(jsonPrompt);
            }
            catch (PluginException e) {
                logger.severe("Error during streaming: " + e.getMessage());
            }
        });
    }

    private void streamPromptCompletion(JsonObject jsonPromptObject) throws PluginException {
        try {
            HttpURLConnection conn = this.openAIAPIService.createHttpConnection(null);
            conn.setRequestProperty("Accept", "text/event-stream");
            String jsonString = jsonPromptObject.toString();
            logger.fine("JSON Object=" + jsonString);
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = jsonString.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            this.currentStreamResult = "";
            int responseCode = conn.getResponseCode();
            logger.fine("POST Response Code: " + responseCode);
            if (responseCode == 200) {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (!line.startsWith("data: ")) continue;
                        String jsonData = line.substring(6);
                        JsonObject responseObject = Json.createReader((Reader)new StringReader(jsonData)).readObject();
                        String content = responseObject.getString("content");
                        boolean stop = responseObject.getBoolean("stop", false);
                        this.currentStreamResult = this.currentStreamResult + content;
                        logger.fine("FullResponse: " + this.currentStreamResult);
                        if (!stop) continue;
                        logger.fine("request completed - adding answer....");
                        this.answer = this.currentStreamResult.trim();
                        this.currentStreamResult = AI_STREAM_EOS;
                    }
                }
            } else {
                throw new PluginException(AIController.class.getSimpleName(), ERROR_PROMPT_INFERENCE, "Error during POST prompt: HTTP Result " + responseCode);
            }
            conn.disconnect();
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
            throw new PluginException(AIController.class.getSimpleName(), ERROR_PROMPT_TEMPLATE, "Exception during POST prompt - " + e.getMessage(), (Exception)e);
        }
    }

    public boolean isStreamingComplete() {
        return this.streamingFuture != null && this.streamingFuture.isDone();
    }

    public String getStreamResult() {
        if (AI_STREAM_EOS.equals(this.currentStreamResult)) {
            this.updateChatHistory();
        }
        return this.currentStreamResult;
    }

    private void updateChatHistory() {
        ItemCollection chatEntry = new ItemCollection();
        chatEntry.setItemValue("question", (Object)this.question);
        chatEntry.setItemValue("answer", (Object)this.answer);
        chatEntry.setItemValue("date", (Object)new Date());
        chatEntry.setItemValue("user", (Object)this.loginController.getUserPrincipal());
        this.chatHistory.add(chatEntry);
        ChildItemController.implodeChildList(this.workflowController.getWorkitem(), this.chatHistory, AI_CHAT_HISTORY);
        this.workflowController.getWorkitem().removeItem("ai.chat.prompt");
    }

    private String buildContextPrompt(String question) {
        ItemCollection workitem = this.workflowController.getWorkitem();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        Object prompt = "<s>";
        prompt = (String)prompt + "Gesch\u00e4ftsprozess: " + workitem.getWorkflowGroup() + "\n";
        prompt = (String)prompt + "Erstellt: " + dateFormat.format(workitem.getItemValueDate("$created")) + " von " + this.userController.getUserName(workitem.getItemValueString("$creator")) + " \n";
        prompt = (String)prompt + "Aktueller Status: " + workitem.getItemValueString("$workflowstatus") + "\n";
        prompt = (String)prompt + "\nVerlauf an Aktivit\u00e4ten in diesem Gesch\u00e4ftsprozess: \n\n";
        List<Integer> years = this.chronicleController.getYears();
        Collections.reverse(years);
        for (int year : years) {
            List<Integer> months = this.chronicleController.getMonths(year);
            Collections.reverse(months);
            for (int month : months) {
                List<ChronicleEntity> chronicleEntries = this.chronicleController.getChroniclePerMonth(year, month);
                Collections.reverse(chronicleEntries);
                for (ChronicleEntity entry : chronicleEntries) {
                    String user = this.userController.getUserName(entry.getUser());
                    List<ItemCollection> cronicleEvents = entry.entries;
                    Collections.reverse(cronicleEvents);
                    for (ItemCollection event : cronicleEvents) {
                        String fileContent;
                        String fileName;
                        FileData fileData;
                        prompt = (String)prompt + dateFormat.format(entry.getDate()) + " - " + user + ": ";
                        String type = event.getItemValueString("type");
                        String message = event.getItemValueString("message");
                        if ("comment".equals(type)) {
                            prompt = (String)prompt + "Kommentar: " + message + "\n";
                        }
                        if ("history".equals(type)) {
                            prompt = (String)prompt + message + "\n";
                        }
                        if ("dms".equals(type) && (fileData = workitem.getFileData(fileName = event.getItemValueString("name"))) != null && fileData.getAttribute("text") != null && (fileContent = fileData.getAttribute("text").toString()) != null && !fileContent.isEmpty()) {
                            prompt = (String)prompt + "Neues Dokument hinzugef\u00fcgt: " + fileName + "\n\n";
                            prompt = (String)prompt + fileContent + "\n\n";
                        }
                        if (!"imixs-ai".equals(type)) continue;
                        prompt = (String)prompt + "Chat: " + message + "\n";
                    }
                }
            }
        }
        prompt = (String)prompt + "</s>\n[INST] " + question + "[/INST]";
        System.out.println((String)prompt);
        return prompt;
    }
}

