/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.faces.application.Application;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.faces.data.WorkflowEvent;
import org.imixs.workflow.office.forms.CustomFormItem;
import org.imixs.workflow.office.forms.CustomFormSection;
import org.imixs.workflow.office.forms.CustomFormService;
import org.imixs.workflow.office.forms.CustomSubForm;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Named
@ConversationScoped
public class CustomFormController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(CustomFormService.class.getName());
    private List<CustomSubForm> subforms = null;
    private List<CustomFormSection> sections;
    private String supportedExpressions = "";
    @Inject
    CustomFormService customFormService;
    @Inject
    WorkflowService workflowService;

    public List<CustomSubForm> getSubforms() {
        return this.subforms;
    }

    public List<CustomFormSection> getSections() {
        return this.sections;
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) throws ModelException {
        if (workflowEvent == null) {
            return;
        }
        if (workflowEvent.getWorkitem() != null && !workflowEvent.getWorkitem().getItemValueString("type").startsWith("workitem")) {
            return;
        }
        int eventType = workflowEvent.getEventType();
        if (21 == eventType || 20 == eventType) {
            this.loadCustomFormExpressions();
            this.computeFieldDefinition(workflowEvent.getWorkitem());
        }
    }

    public void computeFieldDefinition(ItemCollection workitem) throws ModelException {
        logger.fine("---> computeFieldDefinition");
        String content = this.customFormService.updateCustomFieldDefinition(workitem);
        this.sections = new ArrayList<CustomFormSection>();
        if (!content.isEmpty()) {
            logger.finest("......start parsing custom form definition");
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
                Document doc = builder.parse(stream);
                doc.getDocumentElement().normalize();
                Element rootElement = doc.getDocumentElement();
                NodeList nSubformList = rootElement.getElementsByTagName("imixs-subform");
                if (nSubformList != null && nSubformList.getLength() > 0) {
                    this.subforms = new ArrayList<CustomSubForm>();
                    for (int subId = 0; subId < nSubformList.getLength(); ++subId) {
                        Element nSubFormElement = (Element)nSubformList.item(subId);
                        String label = nSubFormElement.getAttribute("label");
                        String sReadOnly = nSubFormElement.getAttribute("readonly");
                        boolean bReadOnly = false;
                        if (sReadOnly != null && !sReadOnly.isEmpty()) {
                            bReadOnly = Boolean.parseBoolean(sReadOnly);
                        }
                        CustomSubForm customSubForm = new CustomSubForm("subform-" + (subId + 1), label, bReadOnly);
                        this.sections = this.parseSectionList(nSubFormElement, bReadOnly, workitem);
                        customSubForm.setSections(this.sections);
                        this.subforms.add(customSubForm);
                    }
                } else {
                    this.sections = this.parseSectionList(rootElement, false, workitem);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.warning("Unable to parse custom form definition: " + e.getMessage());
                return;
            }
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (this.getSubforms() == null || this.getSubforms().size() == 0) {
            for (CustomFormSection _section : this.getSections()) {
                _section.setReadonly(readOnly);
                for (CustomFormItem _item : _section.getItems()) {
                    _item.setReadonly(readOnly);
                }
            }
        } else {
            for (CustomSubForm _subform : this.getSubforms()) {
                for (CustomFormSection _section : _subform.getSections()) {
                    _section.setReadonly(readOnly);
                    for (CustomFormItem _item : _section.getItems()) {
                        _item.setReadonly(readOnly);
                    }
                }
            }
        }
    }

    private List<CustomFormSection> parseSectionList(Element parentNode, boolean readOnly, ItemCollection workitem) throws ModelException {
        ArrayList<CustomFormSection> result = new ArrayList<CustomFormSection>();
        boolean defaultReadOnly = false;
        NodeList nSectionList = parentNode.getElementsByTagName("imixs-form-section");
        for (int temp = 0; temp < nSectionList.getLength(); ++temp) {
            Node nSectionNode = nSectionList.item(temp);
            logger.finest("parsing section...");
            if (nSectionNode.getNodeType() != 1) continue;
            Element eSectionElement = (Element)nSectionNode;
            if (readOnly) {
                defaultReadOnly = true;
            } else {
                String sReadOnly = eSectionElement.getAttribute("readonly");
                defaultReadOnly = false;
                if (sReadOnly != null && !sReadOnly.isEmpty()) {
                    defaultReadOnly = Boolean.parseBoolean(sReadOnly);
                }
            }
            CustomFormSection customSection = new CustomFormSection(eSectionElement.getAttribute("label"), eSectionElement.getAttribute("columns"), eSectionElement.getAttribute("path"), defaultReadOnly);
            customSection.setItems(this.findItems(eSectionElement, customSection.getColumns(), defaultReadOnly, workitem));
            result.add(customSection);
        }
        return result;
    }

    private List<CustomFormItem> findItems(Element sectionElement, String _columns, boolean readOnly, ItemCollection workitem) throws ModelException {
        ArrayList<CustomFormItem> result = new ArrayList<CustomFormItem>();
        int span = 12;
        if ("2".equals(_columns)) {
            span = 6;
        }
        if ("3".equals(_columns)) {
            span = 4;
        }
        if ("4".equals(_columns)) {
            span = 3;
        }
        if ("6".equals(_columns)) {
            span = 2;
        }
        NodeList itemList = sectionElement.getElementsByTagName("item");
        for (int temp = 0; temp < itemList.getLength(); ++temp) {
            Node itemNode = itemList.item(temp);
            logger.finest("......parsing item...");
            if (itemNode.getNodeType() != 1) continue;
            Element itemElement = (Element)itemNode;
            if (itemElement.hasAttribute("span")) {
                try {
                    span = Integer.parseInt(itemElement.getAttribute("span"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean defaultReadOnly = false;
            defaultReadOnly = readOnly ? true : this.evaluateBoolean(itemElement.getAttribute("readonly"));
            String defaultValue = itemElement.getTextContent();
            if (defaultValue != null && !defaultValue.isEmpty()) {
                String itemName = itemElement.getAttribute("name");
                try {
                    defaultValue = CustomFormController.getInnerXMLContent(itemElement);
                    if (!workitem.hasItem(itemName)) {
                        if (defaultValue.contains("$created")) {
                            workitem.setItemValue(itemElement.getAttribute("name"), (Object)new Date());
                        } else {
                            defaultValue = this.workflowService.adaptText(defaultValue, workitem);
                            workitem.setItemValue(itemElement.getAttribute("name"), (Object)defaultValue);
                        }
                    }
                }
                catch (PluginException e) {
                    logger.warning("failed to adapt default value for item " + itemName + " : " + e.getMessage());
                }
            }
            CustomFormItem customItem = new CustomFormItem(itemElement.getAttribute("name"), itemElement.getAttribute("type"), itemElement.getAttribute("label"), this.evaluateBoolean(itemElement.getAttribute("required")), defaultReadOnly, this.evaluateBoolean(itemElement.getAttribute("disabled")), itemElement.getAttribute("options"), itemElement.getAttribute("path"), this.evaluateBoolean(itemElement.getAttribute("hide")), span);
            result.add(customItem);
        }
        return result;
    }

    public static String getInnerXMLContent(Element element) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(element), new StreamResult(writer));
            String xmlString = writer.toString().trim();
            Pattern pattern = Pattern.compile("<" + element.getNodeName() + "[^>]*>(.*?)</" + element.getNodeName() + ">", 32);
            Matcher matcher = pattern.matcher(xmlString);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return element.getTextContent();
    }

    private boolean evaluateBoolean(String expression) throws ModelException {
        if (expression == null || expression.isEmpty()) {
            return false;
        }
        if (expression.startsWith("#{") && expression.endsWith("}")) {
            if (this.supportedExpressions.contains(expression)) {
                FacesContext ctx = FacesContext.getCurrentInstance();
                Application app = ctx.getApplication();
                boolean result = (Boolean)app.evaluateExpressionGet(ctx, expression, Boolean.class);
                return result;
            }
            throw new ModelException("INVALID_MODEL_ENTRY", "The custom-form expression is not allowed: " + expression);
        }
        return Boolean.parseBoolean(expression);
    }

    private void loadCustomFormExpressions() {
        block9: {
            try {
                StringBuilder resultStringBuilder = new StringBuilder();
                try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getFileFromResourceAsStream("customform.expressions")));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        resultStringBuilder.append(line).append("\n");
                    }
                }
                this.supportedExpressions = resultStringBuilder.toString();
            }
            catch (Exception e) {
                logger.warning("unable to find customform.expressions in current classpath");
                if (!logger.isLoggable(Level.FINE)) break block9;
                e.printStackTrace();
            }
        }
    }

    private InputStream getFileFromResourceAsStream(String fileName) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new IllegalArgumentException("file not found! " + fileName);
        }
        return inputStream;
    }
}

