/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.enterprise.context.ConversationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.imixs.marty.team.TeamController;
import org.imixs.workflow.ItemCollection;

@Named
@ConversationScoped
public class SpaceRefFormController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    TeamController teamController;
    private static Logger logger = Logger.getLogger(SpaceRefFormController.class.getName());

    public List<ItemCollection> getSpaces(ItemCollection workitem, String options) {
        if (options == null) {
            options = "";
        }
        List result = null;
        result = options.toLowerCase().contains("byprocess=true") ? this.teamController.getSpacesByProcessId(workitem.getItemValueString("process.ref")) : this.teamController.getSpaces();
        if (options.contains("regex=")) {
            String _regex = SpaceRefFormController.extractRegexValue(options);
            Pattern pattern = Pattern.compile(_regex);
            return result.stream().filter(space -> pattern.matcher(space.getItemValueString("name")).matches()).collect(Collectors.toList());
        }
        return result;
    }

    public String setDefaultSpace(ItemCollection workitem, String options) {
        if (options == null) {
            options = "";
        }
        if (!workitem.getItemValueString("space.ref").isEmpty()) {
            return "";
        }
        ItemCollection defaultSpace = null;
        List<ItemCollection> _spaceList = this.getSpaces(workitem, options);
        if (_spaceList != null) {
            for (ItemCollection space : _spaceList) {
                if (options.toLowerCase().contains("default-selection=assist") && space.getItemValueBoolean("isAssist")) {
                    defaultSpace = space;
                    break;
                }
                if (options.toLowerCase().contains("default-selection=team") && space.getItemValueBoolean("isTeam")) {
                    defaultSpace = space;
                    break;
                }
                if (options.toLowerCase().contains("default-selection=manager") && space.getItemValueBoolean("isManager")) {
                    defaultSpace = space;
                    break;
                }
                if (!options.toLowerCase().contains("default-selection=member") || !space.getItemValueBoolean("isMember")) continue;
                defaultSpace = space;
                break;
            }
        }
        if (defaultSpace != null) {
            workitem.setItemValue("space.ref", (Object)defaultSpace.getUniqueID());
            workitem.setItemValue("space.parent.name", (Object)defaultSpace.getItemValueString("space.parent.name"));
            workitem.setItemValue("space.name", (Object)defaultSpace.getItemValueString("space.name"));
            return defaultSpace.getUniqueID();
        }
        return "";
    }

    private static String extractRegexValue(String input) {
        Pattern pattern = Pattern.compile("regex=([^;]+)");
        Matcher matcher = pattern.matcher(input);
        return matcher.find() ? matcher.group(1) : null;
    }
}

