/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.config;

import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.marty.security.UserGroupService;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.faces.data.WorkflowEvent;

@Named
@SessionScoped
public class AccessRoleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    UserGroupService userGroupService;
    @Inject
    WorkflowController workflowController;
    private String role;
    public static final String[] ACCESS_ROLES = new String[]{"org.imixs.ACCESSLEVEL.MANAGERACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.NOACCESS"};
    private static Logger logger = Logger.getLogger(AccessRoleController.class.getName());

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) {
        if (workflowEvent == null || workflowEvent.getWorkitem() == null) {
            return;
        }
        if (!workflowEvent.getWorkitem().getItemValueString("type").startsWith("profile")) {
            return;
        }
        int eventType = workflowEvent.getEventType();
        if (21 == eventType) {
            List groups = workflowEvent.getWorkitem().getItemValue("txtgroups");
            ArrayList<String> accessGroupList = new ArrayList<String>(Arrays.asList(ACCESS_ROLES));
            if (groups.size() == 1 && accessGroupList.contains(groups.get(0))) {
                this.setUserRole((String)groups.get(0));
                return;
            }
            for (String coreRole : accessGroupList) {
                if (!groups.contains(coreRole)) continue;
                this.setUserRole(coreRole);
                return;
            }
            logger.warning("profile does not contain new core role! - trying migration....");
            for (String group : groups) {
                String newrole = this.userGroupService.getCoreGroupName(group);
                if (newrole == null) continue;
                this.setUserRole(newrole);
                return;
            }
            logger.severe("unable to detect a valid group!");
        }
        if (22 == eventType) {
            workflowEvent.getWorkitem().setItemValue("txtGroups", (Object)this.getUserRole());
        }
    }

    public void setUserRole(String role) {
        this.role = role;
    }

    public String getUserRole() {
        return this.role;
    }

    public String[] getAccessRoles() {
        return ACCESS_ROLES;
    }
}

