/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.EJB;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import jakarta.enterprise.event.Observes;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.ProcessingEvent;
import org.imixs.workflow.exceptions.ModelException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class CustomFormService
implements Serializable {
    @EJB
    ModelService modelService;
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(CustomFormService.class.getName());

    public void onWorkflowEvent(@Observes ProcessingEvent processingEvent) throws ModelException {
        if (processingEvent == null) {
            return;
        }
        if (processingEvent.getDocument() != null && !processingEvent.getDocument().getItemValueString("type").startsWith("workitem")) {
            return;
        }
        int eventType = processingEvent.getEventType();
        if (1 == eventType || 2 == eventType) {
            this.updateCustomFieldDefinition(processingEvent.getDocument());
        }
    }

    public String updateCustomFieldDefinition(ItemCollection workitem) throws ModelException {
        logger.fine("---> updateCustomFieldDefinition");
        String content = this.fetchFormDefinitionFromModel(workitem);
        if (content.isEmpty()) {
            content = workitem.getItemValueString("txtWorkflowEditorCustomForm");
        } else {
            workitem.replaceItemValue("txtWorkflowEditorCustomForm", (Object)content);
        }
        return content;
    }

    private String fetchFormDefinitionFromModel(ItemCollection workitem) {
        ItemCollection task;
        try {
            task = this.modelService.getModelManager().loadTask(workitem);
        }
        catch (ModelException e) {
            logger.warning("unable to parse data object in model: " + e.getMessage());
            return "";
        }
        List dataObjects = task.getItemValue("dataObjects");
        for (List dataObject : dataObjects) {
            String templateName = (String)dataObject.get(0);
            String content = (String)dataObject.get(1);
            if (!content.contains("<imixs-form>")) continue;
            logger.finest("......DataObject name=" + templateName);
            logger.finest("......DataObject content=" + content);
            return content;
        }
        return "";
    }
}

