/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.FacesValidator;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import org.iban4j.IbanFormat;
import org.iban4j.IbanFormatException;
import org.iban4j.IbanUtil;
import org.iban4j.InvalidCheckDigitException;
import org.iban4j.UnsupportedCountryException;

@FacesValidator(value="imixsIBANValidator")
public class IBANValidator
implements Validator<String> {
    public void validate(FacesContext context, UIComponent component, String value) throws ValidatorException {
        if (value != null && !value.isEmpty()) {
            try {
                if (value.contains(" ")) {
                    IbanUtil.validate((String)value, (IbanFormat)IbanFormat.Default);
                } else {
                    IbanUtil.validate((String)value, (IbanFormat)IbanFormat.None);
                }
            }
            catch (IbanFormatException | InvalidCheckDigitException | UnsupportedCountryException e) {
                throw new ValidatorException(new FacesMessage(e.getMessage()));
            }
        }
    }
}

