/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.ejb.EJB;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.event.Observes;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.faces.data.WorkflowEvent;

@Named
@SessionScoped
public class SuggestInputController
implements Serializable {
    public static final int MAX_RESULT = 30;
    static Logger logger = Logger.getLogger(SuggestInputController.class.getName());
    @EJB
    DocumentService documentService = null;
    @EJB
    SchemaService schemaService;
    @Inject
    protected WorkflowController workflowController;
    private static final long serialVersionUID = 1L;
    private List<ItemCollection> searchResult = null;

    public List<ItemCollection> getSearchResult() {
        return this.searchResult;
    }

    public void reset() {
        this.searchResult = new ArrayList<ItemCollection>();
        logger.finest("reset");
    }

    public void reset(AjaxBehaviorEvent event) {
        this.reset();
    }

    public void update(ItemCollection workitem, ItemCollection suggest, String itemList) {
        String[] itemNames;
        logger.finest("......update " + itemList + "...");
        for (String itemName : itemNames = itemList.split("[\\s,;]+")) {
            workitem.replaceItemValue(itemName, (Object)suggest.getItemValue(itemName));
        }
        this.reset();
    }

    public void search(String keyItemName, String input, String searchItemList, String query) {
        input = this.workflowController.getWorkitem().getItemValueString(keyItemName);
        if (input == null || input.length() < 3) {
            return;
        }
        logger.finest("......search for=" + input);
        this.searchResult = this.searchEntity(keyItemName, searchItemList, input, query);
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) {
        this.reset();
    }

    public String getDisplayLine(String displayItemList, ItemCollection suggestItemCol) {
        String[] itemNames;
        Object result = "";
        for (String itemName : itemNames = displayItemList.split("[\\s,;]+")) {
            result = (String)result + suggestItemCol.getItemValueString(itemName) + " | ";
        }
        if (((String)result).endsWith(" | ")) {
            result = ((String)result).substring(0, ((String)result).length() - 3);
        }
        return result;
    }

    private List<ItemCollection> searchEntity(String keyItemName, String searccItemList, String phrase, String _query) {
        long l = System.currentTimeMillis();
        ArrayList<ItemCollection> searchResult = new ArrayList<ItemCollection>();
        if (phrase == null || phrase.isEmpty()) {
            return searchResult;
        }
        Collection col = null;
        try {
            String currentID;
            phrase = phrase.trim();
            phrase = this.schemaService.normalizeSearchTerm(phrase);
            Object sQuery = null;
            if (_query != null && !_query.isEmpty()) {
                sQuery = _query;
                sQuery = ((String)sQuery).replace("'", "\"");
            } else {
                sQuery = "(type:\"workitem\" OR type:\"workitemarchive\")";
                sQuery = (String)sQuery + " AND ($workflowgroup:\"" + this.workflowController.getWorkitem().getWorkflowGroup() + "\")";
            }
            if (this.workflowController.getWorkitem() != null && !(currentID = this.workflowController.getWorkitem().getUniqueID()).isEmpty()) {
                sQuery = (String)sQuery + " AND NOT($uniqueid:" + currentID + ") ";
            }
            String[] itemNames = searccItemList.split("[\\s,;]+");
            sQuery = (String)sQuery + " AND (";
            for (String itemName : itemNames) {
                sQuery = (String)sQuery + "(" + itemName + ":(" + phrase + "*)) OR ";
            }
            sQuery = ((String)sQuery).substring(0, ((String)sQuery).length() - 3);
            sQuery = (String)sQuery + ")";
            logger.finest("......search: " + (String)sQuery);
            col = this.documentService.find((String)sQuery, 30, 0, "$modified", true);
            logger.finest("......found: " + col.size());
        }
        catch (Exception e) {
            logger.warning("  lucene error - " + e.getMessage());
        }
        long l1 = System.currentTimeMillis();
        Set uniqueResultList = col.stream().collect(Collectors.toCollection(() -> new TreeSet<ItemCollection>(new SuggestItemCollectionComparator(keyItemName))));
        logger.finest("...filtert result list in " + (System.currentTimeMillis() - l1) + "ms");
        searchResult.addAll(uniqueResultList);
        Collections.sort(searchResult, new ItemCollectionComparator(keyItemName, true));
        logger.finest("...computed suggestion result in " + (System.currentTimeMillis() - l) + "ms");
        return searchResult;
    }

    class SuggestItemCollectionComparator
    implements Comparator<ItemCollection> {
        String itemName;

        public SuggestItemCollectionComparator(String aItemName) {
            this.itemName = aItemName;
        }

        @Override
        public int compare(ItemCollection e1, ItemCollection e2) {
            return e1.getItemValueString(this.itemName).compareTo(e2.getItemValueString(this.itemName));
        }
    }
}

