/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.enterprise.context.RequestScoped;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.faces.data.WorkflowController;

@Named
@RequestScoped
public class ValidationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ValidationController.class.getName());
    private boolean required = true;
    @Inject
    WorkflowController workflowController;
    @Inject
    WorkflowService workflowService;

    public boolean isRequired() throws PluginException, ModelException {
        this.required = false;
        if (this.workflowController != null && this.workflowController.getWorkitem() != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            ExternalContext ec = context.getExternalContext();
            Map paramValues = ec.getRequestParameterValuesMap();
            block0: for (String id : paramValues.keySet()) {
                int eventPos = id.indexOf(":imixs_workflow_eventid_");
                if (eventPos <= -1) continue;
                this.required = true;
                String eventid = id.substring(eventPos + 24);
                if (eventid == null || eventid.isEmpty()) continue;
                List eventList = null;
                eventList = this.workflowController.getEvents();
                for (ItemCollection event : eventList) {
                    if (!eventid.equals(event.getItemValueString("numactivityid"))) continue;
                    logger.finest("......evaluate validation rule for event " + eventid);
                    ItemCollection evalItemCollection = this.workflowService.evalWorkflowResult(event, "validation", this.workflowController.getWorkitem());
                    if (evalItemCollection == null || evalItemCollection.getItemValueBoolean("required")) continue;
                    logger.finest("validation: event=" + eventid + " required=false");
                    this.required = false;
                    continue block0;
                }
            }
        }
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getConfirmMessage(ItemCollection event) {
        try {
            ItemCollection evalItemCollection = this.workflowService.evalWorkflowResult(event, "validation", this.workflowController.getWorkitem());
            if (evalItemCollection != null) {
                logger.finest("......evaluate validation confirm message");
                String message = evalItemCollection.getItemValueString("confirm");
                return message;
            }
        }
        catch (PluginException e) {
            logger.warning("Failed to evaluate the event confirm message: " + e.getMessage());
        }
        return null;
    }
}

