/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.ejb.EJB;
import jakarta.enterprise.context.RequestScoped;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.office.util.WorkitemHelper;

@Named
@RequestScoped
public class WorkitemLinkController
implements Serializable {
    public static final String LINK_PROPERTY = "$workitemref";
    public static final String LINK_PROPERTY_DEPRECATED = "txtworkitemref";
    public static final int MAX_SEARCH_RESULT = 1000;
    public static Logger logger = Logger.getLogger(WorkitemLinkController.class.getName());
    private Map<Integer, List<ItemCollection>> searchCache = null;
    private Map<Integer, List<ItemCollection>> referencesCache = null;
    private Map<Integer, List<ItemCollection>> externalReferencesCache = null;
    private List<ItemCollection> searchResult = new ArrayList<ItemCollection>();
    @EJB
    protected WorkflowService workflowService;
    @EJB
    protected SchemaService schemaService;
    @Inject
    protected WorkflowController workflowController;
    private static final long serialVersionUID = 1L;

    public WorkitemLinkController() {
        this.searchCache = new HashMap<Integer, List<ItemCollection>>();
        this.referencesCache = new HashMap<Integer, List<ItemCollection>>();
        this.externalReferencesCache = new HashMap<Integer, List<ItemCollection>>();
    }

    public void searchWorkitems() {
        FacesContext fc = FacesContext.getCurrentInstance();
        String _phrase = (String)fc.getExternalContext().getRequestParameterMap().get("phrase");
        String options = (String)fc.getExternalContext().getRequestParameterMap().get("options");
        if (_phrase == null) {
            return;
        }
        logger.finest("......workitemLink search prase '" + _phrase + "'  options=" + options);
        this.searchWorkitems(_phrase, options);
    }

    public List<ItemCollection> searchWorkitems(String phrase, String filter) {
        int searchHash = WorkitemLinkController.computeSearchHash(phrase, filter);
        this.searchResult = this.searchCache.get(searchHash);
        if (this.searchResult != null) {
            return this.searchResult;
        }
        logger.finest(".......search workitem links : " + phrase);
        if (phrase == null || phrase.isEmpty()) {
            this.searchResult = new ArrayList<ItemCollection>();
            this.searchCache.put(searchHash, this.searchResult);
            return this.searchResult;
        }
        this.searchResult = new ArrayList<ItemCollection>();
        List col = null;
        Object sQuery = "";
        try {
            phrase = phrase.trim().toLowerCase();
            phrase = this.schemaService.escapeSearchTerm(phrase);
            phrase = this.schemaService.normalizeSearchTerm(phrase);
            sQuery = (String)sQuery + "((type:workitem) OR (type:workitemarchive)) AND  (*" + phrase + "*)";
            if (filter != null && !"".equals(filter.trim())) {
                String sNewFilter = filter.trim().replace(".", "?");
                sQuery = (String)sQuery + " AND (" + (String)sNewFilter + ") ";
            }
            logger.finest("......query=" + (String)sQuery);
            col = this.workflowService.getDocumentService().find((String)sQuery, 1000, 0);
            if (col != null) {
                for (ItemCollection aWorkitem : col) {
                    this.searchResult.add(WorkitemHelper.clone(aWorkitem));
                }
                Collections.sort(this.searchResult, new ItemCollectionComparator("$workflowabstract", true));
            }
        }
        catch (Exception e) {
            logger.warning("Search error query = '" + (String)sQuery + "'  - " + e.getMessage());
        }
        this.searchCache.put(searchHash, this.searchResult);
        return this.searchResult;
    }

    public List<ItemCollection> getSearchResult() {
        return this.searchResult;
    }

    public static int computeSearchHash(String _phrase, String _filter) {
        int hash = 0;
        if (_phrase != null && !_phrase.isEmpty()) {
            hash = Objects.hash(hash, _phrase);
        }
        if (_filter != null && !_filter.isEmpty()) {
            hash = Objects.hash(hash, _filter);
        }
        return hash;
    }

    public List<ItemCollection> getReferences() {
        return this.getReferences("");
    }

    public List<ItemCollection> getReferences(String filter) {
        long l = System.currentTimeMillis();
        List<Object> result = new ArrayList<ItemCollection>();
        if (this.workflowController.getWorkitem() == null) {
            return result;
        }
        logger.finest("......lookup references for: " + filter);
        int searchHash = WorkitemLinkController.computeSearchHash(this.workflowController.getWorkitem().getUniqueID(), filter);
        result = this.referencesCache.get(searchHash);
        if (result != null) {
            return result;
        }
        List refList = null;
        result = new ArrayList();
        refList = !this.workflowController.getWorkitem().hasItem(LINK_PROPERTY) && this.workflowController.getWorkitem().hasItem(LINK_PROPERTY_DEPRECATED) ? this.workflowController.getWorkitem().getItemValue(LINK_PROPERTY_DEPRECATED) : this.workflowController.getWorkitem().getItemValue(LINK_PROPERTY);
        if (refList != null && !refList.isEmpty()) {
            logger.finest("... we have " + refList.size() + " references stored");
            Object sQuery = "(";
            for (String ref : refList) {
                if (ref == null || ref.trim().isEmpty()) continue;
                sQuery = (String)sQuery + "$uniqueid:\"" + ref + "\" OR ";
            }
            if (!((String)sQuery).contains("$uniqueid")) {
                return result;
            }
            if (((String)sQuery).endsWith("OR ")) {
                sQuery = ((String)sQuery).substring(0, ((String)sQuery).lastIndexOf("OR "));
            }
            sQuery = (String)sQuery + ")";
            if (filter != null && !"".equals(filter.trim())) {
                String sNewFilter = filter.trim().replace(".", "?");
                sQuery = (String)sQuery + " AND (" + sNewFilter + ") ";
            }
            logger.finest("......query=" + (String)sQuery);
            List workitems = null;
            try {
                workitems = this.workflowService.getDocumentService().findStubs((String)sQuery, 1000, 0, "$created", true);
            }
            catch (QueryException e) {
                e.printStackTrace();
            }
            if (workitems != null) {
                result.addAll(workitems);
            }
        }
        logger.fine("...lookup references for: " + filter + " in " + (System.currentTimeMillis() - l) + "ms");
        this.referencesCache.put(searchHash, result);
        return result;
    }

    public List<ItemCollection> getReferencesByIdList(List<String> ids) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        for (String id : ids) {
            ItemCollection refItemCol = this.workflowService.getWorkItem(id);
            if (refItemCol == null) continue;
            result.add(refItemCol);
        }
        return result;
    }

    public List<ItemCollection> getExternalReferences() {
        return this.getExternalReferences("");
    }

    public List<ItemCollection> getExternalReferences(String filter) {
        List<Object> result = new ArrayList<ItemCollection>();
        if (this.workflowController.getWorkitem() == null) {
            return result;
        }
        String uniqueid = this.workflowController.getWorkitem().getUniqueID();
        if ("".equals(uniqueid)) {
            return result;
        }
        int searchHash = WorkitemLinkController.computeSearchHash(uniqueid, filter);
        result = this.externalReferencesCache.get(searchHash);
        if (result != null) {
            return result;
        }
        Object sQuery = "(";
        sQuery = " (type:\"workitem\" OR type:\"workitemarchive\") AND ($workitemref:\"" + uniqueid + "\"  OR txtworkitemref:\"" + uniqueid + "\")";
        List workitems = null;
        try {
            workitems = this.workflowService.getDocumentService().findStubs((String)sQuery, 1000, 0, "$lasteventdate", true);
        }
        catch (QueryException e) {
            e.printStackTrace();
        }
        Collections.sort(workitems, new ItemCollectionComparator("$created", true));
        result = new ArrayList();
        if (filter != null && !filter.isEmpty()) {
            for (ItemCollection itemcol : workitems) {
                if (!WorkitemHelper.matches(itemcol, filter)) continue;
                result.add(itemcol);
            }
        } else {
            result.addAll(workitems);
        }
        this.externalReferencesCache.put(searchHash, result);
        return result;
    }

    public ItemCollection getWorkitem(String id) {
        return this.workflowService.getWorkItem(id);
    }
}

