/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.textadapter;

import jakarta.ejb.Stateless;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.TextEvent;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.office.forms.WorkitemLinkController;
import org.imixs.workflow.util.XMLParser;

@Stateless
public class WorkitemRefAdapter {
    private static Logger logger = Logger.getLogger(WorkitemRefAdapter.class.getName());
    @Inject
    protected WorkflowController workflowController;
    @Inject
    protected WorkitemLinkController workitemLinkController;

    public void onEvent(@Observes TextEvent event) {
        Object text = event.getText();
        String textResult = "";
        if (text == null) {
            return;
        }
        List tagList = XMLParser.findTags((String)text, (String)"workitemref");
        logger.finest(tagList.size() + " tags found");
        for (String tag : tagList) {
            String sItemName;
            String filter = XMLParser.findAttribute((String)tag, (String)"filter");
            List<ItemCollection> list = this.workitemLinkController.getReferences(filter);
            if (list == null || list.size() == 0) {
                return;
            }
            ItemCollection refWorkItem = list.get(0);
            if (refWorkItem.hasItem(sItemName = XMLParser.findTagValue((String)tag, (String)"workitemref"))) {
                textResult = refWorkItem.getItemValueString(sItemName);
            } else {
                refWorkItem = this.workflowController.getDocumentService().load(refWorkItem.getUniqueID());
                textResult = refWorkItem.getItemValueString(sItemName);
            }
            int iStartPos = ((String)text).indexOf(tag);
            int iEndPos = ((String)text).indexOf(tag) + tag.length();
            text = ((String)text).substring(0, iStartPos) + textResult + ((String)text).substring(iEndPos);
        }
        event.setText((String)text);
    }
}

