/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class MinutePlugin
extends AbstractPlugin {
    private static Logger logger = Logger.getLogger(MinutePlugin.class.getName());
    public static final String CHILD_ITEM_PROPERTY = "_ChildItems";
    public static final String RESET_MINUTE_VERSION_HISTORY = "resetminuteversionhistory";

    public ItemCollection run(ItemCollection documentContext, ItemCollection documentActivity) throws PluginException {
        if (documentContext.hasItem("$uniqueidsource") && documentContext.getItemValueBoolean("$isversion")) {
            String masterUniqueID = documentContext.getItemValueString("$uniqueidsource");
            ItemCollection master = this.getWorkflowService().getWorkItem(masterUniqueID);
            if (master != null) {
                List<ItemCollection> childs = this.explodeChildList(documentContext);
                ArrayList<ItemCollection> newMinuteList = new ArrayList<ItemCollection>();
                for (ItemCollection minute : childs) {
                    String stype = minute.getItemValueString("minute.type");
                    if (minute == null || !stype.equals("task")) continue;
                    newMinuteList.add(minute);
                }
                this.implodeChildList(documentContext, newMinuteList);
                logger.fine("Copied " + newMinuteList.size() + " sucessfull");
            }
            logger.fine("reset itemvalue $CREATED for new version...");
            documentContext.removeItem("$created");
            ItemCollection evalResult = this.getWorkflowService().evalWorkflowResult(documentActivity, "item", documentContext);
            if (evalResult != null && evalResult.getItemValueBoolean(RESET_MINUTE_VERSION_HISTORY)) {
                logger.fine("reset version history....");
                documentContext.replaceItemValue("$WorkItemID", (Object)WorkflowKernel.generateUniqueID());
                documentContext.removeItem(RESET_MINUTE_VERSION_HISTORY);
            }
        }
        return documentContext;
    }

    protected void implodeChildList(ItemCollection workitem, List<ItemCollection> childItems) {
        ArrayList<Map> mapOrderItems = new ArrayList<Map>();
        if (childItems != null) {
            logger.fine("Convert child items into Map...");
            for (ItemCollection orderItem : childItems) {
                mapOrderItems.add(orderItem.getAllItems());
            }
            workitem.replaceItemValue(CHILD_ITEM_PROPERTY, mapOrderItems);
        }
    }

    protected List<ItemCollection> explodeChildList(ItemCollection workitem) {
        ArrayList<ItemCollection> childItems = new ArrayList<ItemCollection>();
        List mapOrderItems = workitem.getItemValue(CHILD_ITEM_PROPERTY);
        int pos = 1;
        for (Object mapOderItem : mapOrderItems) {
            if (!(mapOderItem instanceof Map)) continue;
            ItemCollection itemCol = new ItemCollection((Map)mapOderItem);
            itemCol.replaceItemValue("numPos", (Object)pos);
            childItems.add(itemCol);
            ++pos;
        }
        return childItems;
    }
}

