/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.plugins;

import jakarta.inject.Inject;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.marty.plugins.CommentPlugin;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class PhotoPlugin
extends AbstractPlugin {
    ItemCollection documentContext;
    private static Logger logger = Logger.getLogger(CommentPlugin.class.getName());
    @Inject
    @ConfigProperty(name="photo.maxwidth", defaultValue="1024")
    int photoMaxWidth;
    @Inject
    @ConfigProperty(name="photo.filepattern", defaultValue="[^.]*\\.(jpg|jpeg|png)$")
    String filePattern;

    public ItemCollection run(ItemCollection workItem, ItemCollection documentActivity) throws PluginException {
        try {
            List fileDataList = workItem.getFileData();
            for (FileData fileData : fileDataList) {
                if (!this.isPhoto(fileData)) continue;
                this.resize(fileData);
                workItem.addFileData(fileData);
            }
        }
        catch (Exception e) {
            logger.warning("Unable to resize profile image - " + e.getMessage());
        }
        return workItem;
    }

    public void resize(FileData fileData) throws Exception {
        logger.finest("Image Interceptor started");
        BufferedImage originalImage = this.getImageFromWorkitem(fileData);
        if (originalImage != null && originalImage.getWidth() > this.photoMaxWidth) {
            logger.info("...resize new photo: " + fileData.getName());
            int type = originalImage.getType() == 0 ? 2 : originalImage.getType();
            BufferedImage resizeImageHintJpg = this.resizeImageWithHint(originalImage, type, this.photoMaxWidth);
            if (resizeImageHintJpg != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)resizeImageHintJpg, this.getFormatName(fileData.getName()), baos);
                baos.flush();
                byte[] imageInByte = baos.toByteArray();
                baos.close();
                fileData.setContent(imageInByte);
            }
        }
    }

    private boolean isPhoto(FileData fileData) {
        if (fileData == null) {
            return false;
        }
        if (fileData.getContent().length < 10) {
            return false;
        }
        Pattern pattern = null;
        pattern = Pattern.compile(this.filePattern);
        return pattern == null || pattern.matcher(fileData.getName()).find();
    }

    private BufferedImage getImageFromWorkitem(FileData fileData) {
        byte[] fileContent = fileData.getContent();
        if (fileContent != null && fileContent.length > 2) {
            try {
                Iterator<ImageReader> inReaders = ImageIO.getImageReadersByFormatName(this.getFormatName(fileData.getName()));
                ImageReader imageReader = inReaders.next();
                ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(fileContent));
                imageReader.setInput(iis);
                BufferedImage originalImage = imageReader.read(0);
                return originalImage;
            }
            catch (IOException e) {
                logger.severe("ImageInerceptor - unable to load image from workitem : " + e.getMessage());
                e.printStackTrace();
            }
        }
        return null;
    }

    private String getFormatName(String aFilename) {
        if (aFilename.indexOf(46) == -1) {
            return null;
        }
        String inFormat = aFilename.substring(aFilename.lastIndexOf(46) + 1);
        return inFormat.toLowerCase();
    }

    private BufferedImage resizeImageWithHint(BufferedImage originalImage, int type, int imageMaxWidth) {
        float width = originalImage.getWidth();
        float height = originalImage.getHeight();
        float factor = width / (float)imageMaxWidth;
        int newHeight = (int)(height / factor);
        BufferedImage resizedImage = new BufferedImage(imageMaxWidth, newHeight, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, imageMaxWidth, newHeight, null);
        g.dispose();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return resizedImage;
    }
}

