/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.config;

import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.faces.model.SelectItem;
import jakarta.persistence.OptimisticLockException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.office.config.ConfigService;

@ApplicationScoped
public class ConfigController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ConfigController.class.getName());
    private String name = "CONFIGURATION";
    private ItemCollection configItemCollection = null;
    @EJB
    ConfigService configService;

    @PostConstruct
    public void init() {
        this.configItemCollection = this.configService.loadConfiguration(this.getName());
    }

    public void loadConfiguration() {
        this.configItemCollection = this.configService.loadConfiguration(this.getName(), true);
    }

    public ItemCollection getConfiguration() {
        return this.configItemCollection;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ItemCollection getWorkitem() {
        return this.configItemCollection;
    }

    public List<SelectItem> getSelectItems(String param) throws Exception {
        ArrayList<SelectItem> selection = new ArrayList<SelectItem>();
        if (!this.configItemCollection.hasItem(param)) {
            return selection;
        }
        List valueList = this.configItemCollection.getItemValue(param);
        for (Object aValue : valueList) {
            String sValue;
            String sName = sValue = aValue.toString();
            if (sValue.indexOf("|") > -1) {
                sValue = sValue.substring(0, sValue.indexOf("|"));
                sName = sName.substring(sName.indexOf("|") + 1);
            }
            selection.add(new SelectItem((Object)sName.trim(), sValue.trim()));
        }
        return selection;
    }

    public void save() throws AccessDeniedException {
        this.configItemCollection.replaceItemValue("txtname", (Object)this.getName());
        try {
            this.configItemCollection = this.configService.save(this.configItemCollection);
            logger.info("...configuration " + this.getName() + " updated!");
        }
        catch (OptimisticLockException e) {
            logger.warning("...Failed to save configuration " + this.getName() + " : " + e.getMessage() + " - reloading config!");
            this.configItemCollection = this.configService.loadConfiguration(this.getName(), true);
            throw e;
        }
    }
}

