/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.config;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.marty.profile.ProfileService;
import org.imixs.marty.team.TeamController;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.office.config.ConfigController;
import org.imixs.workflow.office.config.PropertiesLoader;
import org.imixs.workflow.office.model.ModelController;

@Named
@ApplicationScoped
public class SetupController
extends ConfigController {
    private static final long serialVersionUID = 1L;
    public static final String CONFIGURATION_NAME = "BASIC";
    public static final int DEFAULT_PORTLET_SIZE = 5;
    @Inject
    @ConfigProperty(name="setup.system.model", defaultValue="")
    Optional<String> systemModelVersion;
    @Resource(lookup="java:module/ModuleName")
    private String moduleName;
    @Resource(lookup="java:app/AppName")
    private String appName;
    @Inject
    protected ModelController modelController;
    @Inject
    protected TeamController teamController;
    @EJB
    protected DocumentService documentService;
    @EJB
    protected ModelService modelService;
    @EJB
    protected PropertiesLoader martyPropertyLoader;
    @EJB
    protected ProfileService profileService;
    private static Logger logger = Logger.getLogger(SetupController.class.getName());

    public SetupController() {
        this.setName(CONFIGURATION_NAME);
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
        if (!this.systemModelVersion.isPresent() || this.systemModelVersion.get().isEmpty()) {
            logger.warning("Missing imixs.property named 'setup.system.model' - system model can not be validated!");
        } else {
            this.modelService.getBPMNModel(this.systemModelVersion.get());
            logger.info("...System Model '" + String.valueOf(this.systemModelVersion) + "' OK");
        }
        if (!this.getWorkitem().hasItem("$uniqueid")) {
            this.getWorkitem().replaceItemValue("keyenableuserdb", (Object)true);
            this.save();
        }
    }

    public String getSortBy() {
        String result = this.getWorkitem().getItemValueString("sortby");
        if (result.isEmpty()) {
            return "$lasteventdate";
        }
        return result;
    }

    public int getPortletSize() {
        int count = this.getWorkitem().getItemValueInteger("portletViewCount");
        if (count <= 0) {
            count = 5;
        }
        return count;
    }

    public boolean getSortReverse() {
        String result = this.getWorkitem().getItemValueString("sortorder");
        return "0".equals(result);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void reset() {
        logger.info("Reset application cache...");
        this.martyPropertyLoader.reset();
        this.profileService.reset();
        this.teamController.reset();
    }

    @Override
    public void save() throws AccessDeniedException {
        super.save();
        this.martyPropertyLoader.reset();
    }
}

