/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.dataview;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.Conversation;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.imixs.archive.core.SnapshotService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.faces.data.ViewController;
import org.imixs.workflow.faces.data.ViewHandler;
import org.imixs.workflow.office.dataview.DataViewCache;
import org.imixs.workflow.office.dataview.DataViewDefaultExporter;
import org.imixs.workflow.office.dataview.DataViewDefinitionController;
import org.imixs.workflow.office.dataview.DataViewPOIHelper;
import org.imixs.workflow.office.forms.CustomFormController;
import org.imixs.workflow.office.forms.CustomFormSection;
import org.imixs.workflow.poi.XSSFUtil;

@Named
@ConversationScoped
public class DataViewController
extends ViewController {
    private static final long serialVersionUID = 1L;
    public static final String ERROR_CONFIG = "CONFIG_ERROR";
    public static final int MAX_ROWS = 9999;
    private List<CustomFormSection> sections = null;
    private List<ItemCollection> viewItemDefinitions = null;
    protected ItemCollection dataViewDefinition = null;
    private ItemCollection filter;
    private String query;
    private String errorMessage;
    @Inject
    DataViewCache dataViewCache;
    @Inject
    private Conversation conversation;
    @Inject
    private DocumentService documentService;
    @Inject
    private WorkflowService workflowService;
    @Inject
    SnapshotService snapshotService;
    @Inject
    CustomFormController customFormController;
    @Inject
    DataViewDefaultExporter dataViewDefaultExporter;
    @Inject
    ViewHandler viewHandler;
    @Inject
    DataViewDefinitionController dataViewDefinitionController;
    private static Logger logger = Logger.getLogger(DataViewController.class.getName());

    @PostConstruct
    public void init() {
        super.init();
        this.setSortBy("$modified");
        this.setSortReverse(false);
        this.setPageSize(100);
        this.setLoadStubs(false);
    }

    public void onLoad() {
        String uniqueid = null;
        this.startConversation();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!facesContext.isPostback() && !facesContext.isValidationFailed()) {
            FacesContext fc = FacesContext.getCurrentInstance();
            Map paramMap = fc.getExternalContext().getRequestParameterMap();
            uniqueid = (String)paramMap.get("id");
            if (uniqueid == null || uniqueid.isEmpty()) {
                uniqueid = (String)paramMap.get("workitem");
            }
            this.dataViewDefinition = this.documentService.load(uniqueid);
        }
        this.filter = uniqueid != null && !uniqueid.isEmpty() ? this.dataViewCache.get(uniqueid) : new ItemCollection();
        try {
            if (this.dataViewDefinition != null) {
                this.filter.setItemValue("txtWorkflowEditorCustomForm", (Object)this.dataViewDefinition.getItemValue("form"));
                this.filter.setItemValue("name", (Object)this.dataViewDefinition.getItemValueString("name"));
                this.filter.setItemValue("description", (Object)this.dataViewDefinition.getItemValueString("description"));
                this.viewItemDefinitions = DataViewDefinitionController.computeDataViewItemDefinitions(this.dataViewDefinition);
                this.customFormController.computeFieldDefinition(this.filter);
                this.sections = this.customFormController.getSections();
                String sortBy = this.dataViewDefinition.getItemValueString("sort.by");
                if (sortBy.isEmpty()) {
                    sortBy = "$modified";
                }
                this.setSortBy(sortBy);
                this.setSortReverse(this.dataViewDefinition.getItemValueBoolean("sort.reverse"));
                this.setPageIndex(this.filter.getItemValueInteger("pageIndex"));
                if (!this.filter.getItemValueString("query").isEmpty()) {
                    this.query = this.filter.getItemValueString("query");
                    this.viewHandler.getData((ViewController)this);
                }
            }
        }
        catch (ModelException | QueryException e) {
            logger.warning("Failed to load dataview definition: " + e.getMessage());
        }
    }

    public List<ItemCollection> loadData() throws QueryException {
        try {
            return super.loadData();
        }
        catch (Exception e) {
            logger.severe("Failed to load view: " + e.getMessage());
            return new ArrayList<ItemCollection>();
        }
    }

    public ItemCollection getDataViewDefinition() {
        return this.dataViewDefinition;
    }

    public List<CustomFormSection> getSections() {
        return this.sections;
    }

    public List<ItemCollection> getViewItemDefinitions() {
        return this.viewItemDefinitions;
    }

    public ItemCollection getFilter() {
        return this.filter;
    }

    public void setFilter(ItemCollection filter) {
        this.filter = filter;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void run() throws PluginException, QueryException {
        this.reset();
        this.query = this.dataViewDefinition.getItemValueString("query");
        this.query = this.parseQuery(this.query, this.filter);
        logger.info("query=" + this.query);
        this.filter.setItemValue("query", (Object)this.query);
        this.viewHandler.getData((ViewController)this);
        this.dataViewCache.put(this.dataViewDefinition.getUniqueID(), this.filter);
    }

    private String parseQuery(String query, ItemCollection filter) {
        List filterItems = filter.getItemNames();
        for (String itemName : filterItems) {
            String itemValue = filter.getItemValueString(itemName);
            if (filter.getItemValueDate(itemName) != null) {
                String sDateFrom = "191401070000";
                String sDateTo = "211401070000";
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmm");
                itemValue = dateformat.format(filter.getItemValueDate(itemName));
            }
            query = query.replaceAll("(?i)\\{" + Pattern.quote(itemName) + "\\}", itemValue);
        }
        return query;
    }

    public String getQuery() {
        return this.query;
    }

    public void back() {
        this.viewHandler.back((ViewController)this);
        this.filter.setItemValue("pageIndex", (Object)this.getPageIndex());
    }

    public void forward() {
        this.viewHandler.forward((ViewController)this);
        this.filter.setItemValue("pageIndex", (Object)this.getPageIndex());
    }

    protected void startConversation() {
        if (this.conversation.isTransient()) {
            this.conversation.setTimeout((long)(((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getSession().getMaxInactiveInterval() * 1000));
            this.conversation.begin();
            logger.log(Level.FINEST, "......start new conversation, id={0}", this.conversation.getId());
        }
    }

    public String export() throws PluginException, QueryException {
        this.run();
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmm");
        Object targetFileName = this.dataViewDefinition.getItemValueString("poi.targetFilename");
        if (((String)targetFileName).isEmpty()) {
            throw new PluginException(DataViewController.class.getSimpleName(), ERROR_CONFIG, "Missing Excel Export definition - check configuration!");
        }
        logger.info("start export : " + (String)targetFileName + "...");
        logger.fine(this.query);
        FileData fileData = this.loadTemplate();
        if (fileData == null) {
            throw new PluginException(DataViewController.class.getSimpleName(), ERROR_CONFIG, "Missing Excel Export Template - check DataView definition!");
        }
        targetFileName = (String)targetFileName + "_" + dateformat.format(new Date()) + ".xlsx";
        try {
            List invoices;
            int totalCount = this.documentService.count(this.query);
            if (totalCount > 9999) {
                throw new PluginException(DataViewController.class.getSimpleName(), ERROR_CONFIG, "Data can not be exported into Excel because dataset exceeds 9999 rows!");
            }
            String sortBy = this.dataViewDefinition.getItemValueString("sort.by");
            if (sortBy.isEmpty()) {
                sortBy = "$modified";
            }
            if ((invoices = this.documentService.find(this.query, 9999, 0, sortBy, this.dataViewDefinition.getItemValueBoolean("sort.reverse"))).size() > 0) {
                this.dataViewDefaultExporter.insertDataRows(invoices, this.dataViewDefinition, this.viewItemDefinitions, fileData);
            }
            ItemCollection event = new ItemCollection().setItemValue("txtActivityResult", (Object)this.dataViewDefinition.getItemValue("poi.update"));
            ItemCollection poiConfig = this.workflowService.evalWorkflowResult(event, "poi-update", this.dataViewDefinition, false);
            XSSFUtil.poiUpdate((ItemCollection)this.filter, (FileData)fileData, (ItemCollection)poiConfig, (WorkflowService)this.workflowService);
            fileData.setName((String)targetFileName);
            DataViewPOIHelper.downloadExcelFile(fileData);
        }
        catch (IOException | QueryException e) {
            throw new PluginException(DataViewController.class.getSimpleName(), ERROR_CONFIG, "Failed to generate Excel Export: " + e.getMessage());
        }
        return "";
    }

    private FileData loadTemplate() {
        List fileDataList = this.dataViewDefinition.getFileData();
        if (fileDataList != null && fileDataList.size() > 0) {
            String fileName = ((FileData)fileDataList.get(0)).getName();
            return this.snapshotService.getWorkItemFile(this.dataViewDefinition.getUniqueID(), fileName);
        }
        return null;
    }

    public static void downloadExcelFile(FileData fileData) throws IOException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        externalContext.responseReset();
        externalContext.setResponseContentType("application/vnd.ms-excel");
        externalContext.setResponseContentLength(fileData.getContent().length);
        externalContext.setResponseHeader("Content-Disposition", "attachment; filename=\"" + fileData.getName() + "\"");
        OutputStream output = externalContext.getResponseOutputStream();
        output.write(fileData.getContent());
        facesContext.responseComplete();
    }
}

