/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.dataview;

import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.CellCopyPolicy;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.office.dataview.DataViewExportEvent;
import org.imixs.workflow.office.dataview.DataViewPOIHelper;
import org.imixs.workflow.office.forms.AnalyticController;

@Named
@ConversationScoped
public class DataViewDefaultExporter
implements Serializable {
    public static final String ERROR_CONFIG = "CONFIG_ERROR";
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(AnalyticController.class.getName());
    @Inject
    protected Event<DataViewExportEvent> dataViewExportEvents;

    public void insertDataRows(List<ItemCollection> dataset, ItemCollection dataViewDefinition, List<ItemCollection> viewItemDefinitions, FileData fileData) throws PluginException {
        try (ByteArrayInputStream imputStream = new ByteArrayInputStream(fileData.getContent());){
            XSSFWorkbook doc = new XSSFWorkbook((InputStream)imputStream);
            if (this.dataViewExportEvents != null) {
                DataViewExportEvent event = new DataViewExportEvent(dataset, dataViewDefinition, viewItemDefinitions, doc);
                this.dataViewExportEvents.fire((Object)event);
                if (!event.isCompleted()) {
                    this.defaultExport(dataset, dataViewDefinition, viewItemDefinitions, doc);
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            doc.write((OutputStream)byteArrayOutputStream);
            doc.close();
            byte[] newContent = byteArrayOutputStream.toByteArray();
            fileData.setContent(newContent);
        }
        catch (IOException e) {
            throw new PluginException(DataViewPOIHelper.class.getSimpleName(), ERROR_CONFIG, "failed to update excel export: " + e.getMessage());
        }
    }

    private void defaultExport(List<ItemCollection> dataset, ItemCollection dataViewDefinition, List<ItemCollection> viewItemDefinitions, XSSFWorkbook doc) {
        int referenceRowPos;
        String referenceCell = dataViewDefinition.getItemValueString("poi.referenceCell");
        XSSFSheet sheet = doc.getSheetAt(0);
        CellReference cr = new CellReference(referenceCell);
        XSSFRow referenceRow = sheet.getRow(cr.getRow());
        int rowPos = referenceRowPos = referenceRow.getRowNum() + 1;
        int lastRow = 999;
        logger.finest("Last rownum=" + lastRow);
        sheet.shiftRows(rowPos, lastRow, dataset.size(), true, true);
        for (ItemCollection workitem : dataset) {
            logger.finest("......copy row...");
            XSSFRow row = sheet.createRow(rowPos);
            row.copyRowFrom((Row)referenceRow, new CellCopyPolicy());
            int cellNum = 0;
            for (ItemCollection itemDef : viewItemDefinitions) {
                String type = itemDef.getItemValueString("item.type");
                String name = itemDef.getItemValueString("item.name");
                switch (type) {
                    case "xs:double": {
                        row.getCell(cellNum).setCellValue(workitem.getItemValueDouble(name));
                        break;
                    }
                    case "xs:float": {
                        row.getCell(cellNum).setCellValue((double)workitem.getItemValueFloat(name));
                        break;
                    }
                    case "xs:int": {
                        row.getCell(cellNum).setCellValue((double)workitem.getItemValueInteger(name));
                        break;
                    }
                    case "xs:date": {
                        row.getCell(cellNum).setCellValue(workitem.getItemValueDate(name));
                        break;
                    }
                    default: {
                        row.getCell(cellNum).setCellValue(workitem.getItemValueString(name));
                    }
                }
                ++cellNum;
            }
            ++rowPos;
        }
        sheet.shiftRows(referenceRowPos, lastRow + dataset.size(), -1, true, true);
    }
}

