/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.faces.data.WorkflowEvent;

@Named
@ConversationScoped
public class ChildItemController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ChildItemController.class.getName());
    protected List<ItemCollection> childItems = null;
    public static final String CHILD_ITEM_PROPERTY = "_ChildItems";

    public void setChildItems(List<ItemCollection> childItems) {
        this.childItems = childItems;
    }

    public List<ItemCollection> getChildItems() {
        return this.childItems;
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) throws AccessDeniedException {
        int eventType = workflowEvent.getEventType();
        ItemCollection workitem = workflowEvent.getWorkitem();
        if (workitem == null) {
            return;
        }
        if (21 == eventType || 20 == eventType) {
            this.childItems = ChildItemController.explodeChildList(workitem);
        }
        if (22 == eventType) {
            ChildItemController.implodeChildList(workitem, this.childItems);
        }
        if (23 == eventType) {
            this.childItems = ChildItemController.explodeChildList(workitem);
        }
    }

    public void add() {
        if (this.childItems != null) {
            ItemCollection itemCol = new ItemCollection();
            itemCol.replaceItemValue("numPos", (Object)(this.childItems.size() + 1));
            this.childItems.add(itemCol);
        }
    }

    public void remove(int pos) {
        if (this.childItems != null) {
            this.childItems.remove(pos - 1);
        }
        int iPos = 1;
        for (ItemCollection item : this.childItems) {
            item.replaceItemValue("numPos", (Object)iPos);
            ++iPos;
        }
    }

    public double convertDouble(String aValue) {
        if (aValue == null || aValue.isEmpty()) {
            return 0.0;
        }
        return new Double(aValue);
    }

    public static List<ItemCollection> explodeChildList(ItemCollection workitem) {
        return ChildItemController.explodeChildList(workitem, CHILD_ITEM_PROPERTY);
    }

    public static List<ItemCollection> explodeChildList(ItemCollection workitem, String childItemName) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        List mapOrderItems = workitem.getItemValue(childItemName);
        for (Object mapOderItem : mapOrderItems) {
            if (!(mapOderItem instanceof Map)) continue;
            ItemCollection itemCol = new ItemCollection((Map)mapOderItem);
            result.add(itemCol);
        }
        return result;
    }

    public static void implodeChildList(ItemCollection workitem, List<ItemCollection> _childItems) {
        ChildItemController.implodeChildList(workitem, _childItems, CHILD_ITEM_PROPERTY);
    }

    public static void implodeChildList(ItemCollection workitem, List<ItemCollection> _childItems, String childItemName) {
        ArrayList<Map> mapOrderItems = new ArrayList<Map>();
        if (_childItems != null) {
            for (ItemCollection orderItem : _childItems) {
                mapOrderItems.add(orderItem.getAllItems());
            }
            workitem.replaceItemValue(childItemName, mapOrderItems);
        }
    }
}

