/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.enterprise.context.Conversation;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Path;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.faces.data.WorkflowController;

@Named
@ConversationScoped
@Path(value="/travel")
public class WorkitemMobileController
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String version;
    protected String task;
    protected String ref;
    protected boolean redirect = false;
    @Inject
    private Conversation conversation;
    @Inject
    WorkflowController workflowController;
    private static Logger logger = Logger.getLogger(WorkitemMobileController.class.getName());

    public void init() {
        logger.info("-- Init new beleg...");
        logger.info("----- version=" + this.getVersion());
        logger.info("----- task=" + this.getTask());
        logger.info("----- ref=" + this.getRef());
        try {
            if (this.version != null && !this.version.isEmpty()) {
                logger.info("Create mobile workitem...");
                if (this.task == null || this.task.isEmpty()) {
                    this.task = "0";
                }
                this.workflowController.create(this.version, Integer.parseInt(this.task), null);
                this.workflowController.getWorkitem().setItemValue("$workitemref", (Object)this.ref);
                this.workflowController.getWorkitem().setItemValue("$uniqueidref", (Object)this.ref);
                if (!this.redirect && !FacesContext.getCurrentInstance().isPostback()) {
                    try {
                        String url = FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath() + "/pages/workitems/mobile.xhtml?cid=" + this.conversation.getId();
                        logger.info("redirect to: " + url);
                        this.redirect = true;
                        FacesContext.getCurrentInstance().getExternalContext().redirect(url);
                    }
                    catch (IOException url) {}
                }
            }
        }
        catch (NumberFormatException | ModelException e) {
            e.printStackTrace();
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }
}

