/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.EJB;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.ModelManager;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.openbpmn.bpmn.BPMNModel;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class WorkitemService {
    @EJB
    WorkflowService workflowService;
    @EJB
    ModelService modelService;
    private static Logger logger = Logger.getLogger(WorkitemService.class.getName());

    public ItemCollection createWorkItem(ItemCollection parent, String sProcessModelVersion, int aProcessID) throws Exception {
        logger.fine("create workitem...");
        ModelManager modelManager = new ModelManager((WorkflowContext)this.workflowService);
        BPMNModel model = this.modelService.getBPMNModel(sProcessModelVersion);
        ItemCollection processEntity = modelManager.findTaskByID(model, aProcessID);
        if (processEntity == null) {
            throw new Exception("error createWorkItem: Process Entity can not be found (" + sProcessModelVersion + "|" + aProcessID + ")");
        }
        String sEditorID = processEntity.getItemValueString("txteditorid");
        if ("".equals(sEditorID)) {
            sEditorID = "default";
        }
        int processID = processEntity.getItemValueInteger("numProcessID");
        String sModelVersion = processEntity.getItemValueString("$modelversion");
        String sWorkflowGroup = processEntity.getItemValueString("txtworkflowgroup");
        ItemCollection workItem = new ItemCollection();
        workItem.replaceItemValue("type", (Object)"workitem");
        workItem.replaceItemValue("$processID", (Object)processID);
        workItem.replaceItemValue("$writeAccess", (Object)this.workflowService.getUserName());
        workItem.replaceItemValue("$uniqueidRef", (Object)parent.getItemValueString("$uniqueid"));
        workItem.replaceItemValue("$modelversion", (Object)sModelVersion);
        workItem.replaceItemValue("$workflowgroup", (Object)sWorkflowGroup);
        workItem.replaceItemValue("txtworkfloweditorid", (Object)sEditorID);
        return workItem;
    }

    public ItemCollection processWorkItem(ItemCollection aworkitem) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        return this.workflowService.processWorkItem(aworkitem);
    }

    public List<ItemCollection> findAllVersions(ItemCollection workitem) {
        ArrayList<ItemCollection> versions = new ArrayList<ItemCollection>();
        if (null == workitem) {
            return versions;
        }
        List col = null;
        String sRefID = workitem.getItemValueString("$workitemId");
        String refQuery = "( (type:\"workitem\" OR type:\"workitemarchive\" OR type:\"workitemversion\") AND $workitemid:\"" + sRefID + "\")";
        try {
            col = this.workflowService.getDocumentService().findStubs(refQuery, 999, 0, "$lasteventdate", true);
            Collections.sort(col, new ItemCollectionComparator("$modified", true));
            if (col.size() > 1) {
                for (ItemCollection aworkitem : col) {
                    versions.add(aworkitem);
                }
            }
        }
        catch (QueryException e) {
            logger.warning("findAllVersions - invalid query: " + e.getMessage());
        }
        return versions;
    }

    public List<ItemCollection> findAncestorsVersions(ItemCollection workitem) {
        ArrayList<ItemCollection> versions = new ArrayList<ItemCollection>();
        if (null != workitem) {
            String sourceVersion = workitem.getItemValueString("$uniqueidsource");
            while (!sourceVersion.isEmpty()) {
                ItemCollection version = this.workflowService.getWorkItem(sourceVersion);
                versions.add(version);
                sourceVersion = version.getItemValueString("$uniqueidsource");
            }
        }
        return versions;
    }
}

